/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class DebugCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        if (this.parameters != null && this.parameters.length == 1) {
            int level = 0;
            try {
                level = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException ex) {
                this.printUsage();
            }
            this.setLevel(level);
            this.statusCode = 0;
        } else {
            this.printUsage();
            this.statusCode = 0;
        }
    }

    public void printUsage() {
        MOut.G(this).println("debug level = " + GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL);
        MOut.G(this).println("Usage:");
        MOut.G(this).println("debug [0|1|2|3] : Display raw data between you and BMC");
        MOut.G(this).println("level 0 : No raw displayed");
        MOut.G(this).println("level 1 : Human read raw data.");
        MOut.G(this).println("          IPMI Reqeuest (NetFn, Cmd, Data ...)");
        MOut.G(this).println("          BMC  Response (Completion, Data ...)");
        MOut.G(this).println("level 2 : IPMI Message raw format");
        MOut.G(this).println("level 3 : IPMI Message raw format with detailed field list");
    }

    public void setLevel(int level) {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        switch (level) {
            case 0: {
                GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = level;
                MOut.G(this).println("debug level = " + GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL);
                MOut.G(this).println("level 0 : No raw displayed");
                break;
            }
            case 1: {
                GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = level;
                MOut.G(this).println("debug level = " + GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL);
                MOut.G(this).println("level 1 : Human read raw data.");
                MOut.G(this).println("          IPMI Reqeuest (NetFn, Cmd, Data ...)");
                MOut.G(this).println("          BMC  Response (Completion, Data ...)");
                break;
            }
            case 2: {
                GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = level;
                MOut.G(this).println("debug level = " + GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL);
                MOut.G(this).println("level 2 : IPMI Message raw format");
                break;
            }
            case 3: {
                GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = level;
                MOut.G(this).println("debug level = " + GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL);
                MOut.G(this).println("level 3 : IPMI Message raw format with detailed field list");
                break;
            }
            default: {
                this.printUsage();
            }
        }
    }
}

