/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20DelPolicyCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("delPolicy <domain ID> <policy ID>");
            MOut.G(this).println("Domain ID:");
            MOut.G(this).println("0 \u2013 Entire platform");
            MOut.G(this).println("1 \u2013 CPU subsystem");
            MOut.G(this).println("2 \u2013 Memory subsystem");
            this.statusCode = 0;
            return;
        }
        byte did = -1;
        try {
            did = (byte)Integer.parseInt(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        byte pid = -1;
        try {
            pid = (byte)Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMINM20Command.NodeManagerPolicy policy = null;
        try {
            policy = this.ipmiNM20Command.getNodeManagerPolicy(did, pid);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        IPMINM20Command.NodeManagerPolicySetting policySetting = this.ipmiNM20Command.createNodeManagerPolicySetting();
        policySetting.domainID = did;
        policySetting.policyID = pid;
        policySetting.policyConfig = 0;
        policySetting.PolicyException = policy.policyException;
        policySetting.powerLimit = policy.powerLimit;
        policySetting.correctionTimeLimit = policy.correctionTimeLimit;
        policySetting.policyTriggerLimit = policy.policyTriggerLimit;
        policySetting.statisticsReportingPeriod = policy.statisticsReportingPeriod;
        try {
            this.ipmiNM20Command.setNodeManagerPolicy(policySetting);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

