/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MultiInteger;

public abstract class SuperBladeMultiCommand
extends Command {
    int[] indexes;
    Command singleCommand;
    int type;

    private void processIndexes() {
        this.preParameters.remove(0);
        String multiInt = (String)this.preParameters.get(1);
        switch (MultiInteger.validateInteger(multiInt)) {
            case 0: {
                this.indexes = new int[1];
                this.indexes[0] = Integer.parseInt(multiInt);
                this.type = 0;
                break;
            }
            case 2: {
                this.indexes = MultiInteger.parseMultiInteger(multiInt);
                this.type = 2;
                break;
            }
            case 1: {
                this.processStar();
                this.type = 1;
                break;
            }
        }
    }

    public abstract void processStar();

    public void helpGenIntArray(int size) {
        this.indexes = new int[size];
        for (int i = 0; i < size; ++i) {
            this.indexes[i] = i + 1;
        }
    }

    public boolean preValidate() {
        return true;
    }

    @Override
    public void execute() {
        this.processIndexes();
        if (this.indexes == null || this.indexes.length == 0) {
            return;
        }
        if (!this.preValidate()) {
            this.statusCode = 147;
            return;
        }
        try {
            for (int i = 0; i < this.indexes.length; ++i) {
                this.preParameters.remove(1);
                this.preParameters.add(1, "" + this.indexes[i]);
                this.singleCommand.setConfig(this.config);
                this.singleCommand.setPreParameters(this.preParameters);
                this.singleCommand.setParameters(this.parameters);
                if (this.indexes.length != 1) {
                    MOut.G(this).printf("[%2d]:\n", this.indexes[i]);
                }
                this.singleCommand.execute();
                this.statusCode = this.singleCommand.statusCode;
            }
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

