/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class WSISOStatus
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            byte[] status = ipmiOEMWebSettingCommand.getVMDeviceStatus();
            for (int i = 0; i < status.length; ++i) {
                String statusLabel = "";
                switch (status[i]) {
                    case 0: {
                        statusLabel = "IMA File";
                        break;
                    }
                    case 3: {
                        statusLabel = "Disk Device";
                        break;
                    }
                    case 4: {
                        statusLabel = "ISO file through Windows Sharing";
                        break;
                    }
                    case -1: {
                        statusLabel = "Empty device";
                        break;
                    }
                    default: {
                        statusLabel = "(" + ByteUtility.byteToHex(status[i]) + ")";
                    }
                }
                this.statusCode = 0;
                MOut.G(this).println("Device " + (i + 1) + ":" + statusLabel);
            }
        }
        catch (IPMIException e) {
            if (e.getIPMIMessage() != null && e.getIPMIMessage().completionCode == -43) {
                MOut.G(this).println("Please activate SFT-OOB-LIC or SFT-SUM-LIC node product key for this command");
                this.statusCode = 153;
            } else {
                MOut.G(this).println("This device doesn't support WSISO commands");
                this.statusCode = 153;
            }
            return;
        }
    }
}

