/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import nn.pp.drvredir.ConnectionHandlerLite;
import nn.pp.drvredir.DrvRedirIso;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

class ConnectionHandlerLiteIso
extends ConnectionHandlerLite {
    DrvRedirIso iso;
    String filename;
    PrintStream logger;

    ConnectionHandlerLiteIso(RFBProfile prof, PrintStream logger, int msIndex) {
        super(prof, new DrvRedirIso(), logger, msIndex);
        this.iso = (DrvRedirIso)this.drvAccess;
        this.logger = logger;
    }

    void chooseIsoFile(String filename) throws IOException {
        this.filename = filename;
        if (filename == null) {
            throw new IOException(T._("No ISO file chosen"));
        }
        RandomAccessFile file = new RandomAccessFile(new File(filename), "r");
        boolean isValid = this.iso.isFloppy(file) || this.iso.isIso(file);
        try {
            file.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (!isValid) {
            this.logger.println(filename + " is not a valid image file.");
            throw new IOException(T._("Invalid file"));
        }
        ConnectionHandlerLiteIso.debug("Redirecting file " + filename);
    }

    @Override
    void connect() throws Exception {
        File file = new File(this.filename);
        this.iso.openFile(file.getParent(), file.getName());
        this.doConnect();
    }

    @Override
    void disconnect() {
        this.doDisconnect();
        this.iso.closeFile();
    }

    public static void main(String[] args) {
        RFBProfile rfbProfile = new RFBProfile();
        rfbProfile.remoteHost = "192.168.10.245";
        rfbProfile.username = "ADMIN";
        rfbProfile.password = "ADMIN";
        rfbProfile.driveRedirectionNoDrives = 2;
        rfbProfile.driveRedirection = true;
        ConnectionHandlerLiteIso iso = new ConnectionHandlerLiteIso(rfbProfile, System.out, 1);
        try {
            iso.chooseIsoFile("d:\\iso\\cd1.iso");
            iso.connect();
            System.out.println("Done");
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        try {
            Thread.sleep(1000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

