/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rckbd.KeyEventHandler;

public class HotkeyMenu
extends PopupMenu {
    public static final boolean debug = false;
    ServerConsolePanelBase frame;
    KeyEventHandler keh;
    PrintStream logger;
    int keypause;
    int itemCount = 0;
    Menu plain_menu = new Menu();
    static final int KEYDELI_ADD = 240;
    static final int KEYDELI_SEPERATE = 241;
    static final int KEYDELI_PAUSE = 242;
    static final int KEYDELI_RELEASE_LAST = 243;

    public HotkeyMenu(String name, ServerConsolePanelBase frame, KeyEventHandler keh, String[] hotkeys, String[] hotkeycodes, String[] hotkeynames, PrintStream logger, boolean kvm_hot, int keypause) {
        super(name);
        this.frame = frame;
        this.logger = logger;
        this.keh = keh;
        this.keypause = keypause;
        int l = hotkeys.length;
        if (l != hotkeycodes.length) {
            logger.println(T._("Console: WARNING: hotkey definition mismatch, some buttons will be ignored"));
            l = Math.min(hotkeys.length, hotkeycodes.length);
        }
        for (int i = 0; i < l; ++i) {
            try {
                MenuItem b = null;
                MenuItem mItem = null;
                if (hotkeycodes[i] == null || hotkeycodes[i].length() == 0) continue;
                if (hotkeycodes[i].startsWith("kvm")) {
                    if (kvm_hot) {
                        b = new KvmPortItem(hotkeys[i], hotkeycodes[i]);
                        mItem = new KvmPortItem(hotkeys[i], hotkeycodes[i]);
                        ++this.itemCount;
                    }
                } else if (!kvm_hot) {
                    b = new HotKeyItem(hotkeys[i], hotkeycodes[i], hotkeynames[i]);
                    mItem = new HotKeyItem(hotkeys[i], hotkeycodes[i], hotkeynames[i]);
                    ++this.itemCount;
                }
                if (b == null) continue;
                this.add(b);
                this.plain_menu.add(mItem);
                continue;
            }
            catch (ParseException e) {
                logger.println(T._("Console: hotkey error:") + " " + e);
                logger.println(T._("Console: hotkey configuration error: ignored!"));
            }
        }
    }

    public Menu getPlainMenu(String name) {
        this.plain_menu.setLabel(name);
        return this.plain_menu;
    }

    public boolean isEmpty() {
        return this.itemCount <= 0;
    }

    public void _() {
    }

    class KvmPortItem
    extends MenuItem
    implements ActionListener {
        short portno;

        public KvmPortItem(String hotkey, String code) throws ParseException {
            super(hotkey);
            StringTokenizer st = new StringTokenizer(code);
            try {
                st.nextToken();
                this.portno = Short.parseShort(st.nextToken(), 10);
            }
            catch (Exception e) {
                throw new ParseException(code, 0);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            HotkeyMenu.this.frame.console.switchKvmPort(this.portno);
        }
    }

    class HotKeyItem
    extends MenuItem
    implements ActionListener {
        private static final String CONFIRM = "confirm";
        private boolean confirm;
        private Vector codes;

        public HotKeyItem(String hotkey, String codes, String name) throws ParseException {
            this.setButtonKey(hotkey, codes, name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.confirm) {
                ConfirmDialog d = new ConfirmDialog(MessageFormat.format(T._("Do you really want to send \"{0}\"?"), this.getLabel()), T._("Send Key"), 1, true);
                d.show();
                boolean ok = d.ok;
                d.dispose();
                d = null;
                if (!ok) {
                    return;
                }
            }
            Stack<Short> relkeys = new Stack<Short>();
            block8: for (int i = 0; i < this.codes.size(); ++i) {
                Short keynr = (Short)this.codes.elementAt(i);
                short k = keynr;
                switch (k) {
                    case 242: {
                        try {
                            Thread.sleep(HotkeyMenu.this.keypause);
                        }
                        catch (Exception e) {}
                        continue block8;
                    }
                    case 241: {
                        this.releaseStackKeys(relkeys);
                        continue block8;
                    }
                    case 243: {
                        this.releaseLastStackKey(relkeys);
                        continue block8;
                    }
                    case 240: {
                        continue block8;
                    }
                    default: {
                        relkeys.push(keynr);
                        HotkeyMenu.this.keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
                    }
                }
            }
            this.releaseStackKeys(relkeys);
        }

        private void releaseStackKeys(Stack keys) {
            try {
                while (true) {
                    Short keynr = (Short)keys.pop();
                    HotkeyMenu.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
                }
            }
            catch (EmptyStackException emptyStackException) {
                return;
            }
        }

        private void releaseLastStackKey(Stack keys) {
            try {
                Short keynr = (Short)keys.pop();
                HotkeyMenu.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }

        private void setButtonKey(String text, String kcodes, String name) throws ParseException {
            if (text == null || text.length() == 0) {
                throw new ParseException(text, 0);
            }
            String keyText = text.trim();
            this.confirm = false;
            if (keyText.startsWith(CONFIRM)) {
                this.confirm = true;
                keyText = keyText.substring(CONFIRM.length());
                keyText = keyText.trim();
            }
            if (name != null && name.length() > 0) {
                this.setLabel(name + " (" + keyText + ")");
            } else {
                this.setLabel(keyText);
            }
            this.codes = new Vector();
            StringTokenizer st = new StringTokenizer(kcodes);
            while (st.hasMoreTokens()) {
                try {
                    int c = Integer.parseInt(st.nextToken(), 16);
                    this.codes.addElement(new Short((short)c));
                }
                catch (NumberFormatException e) {
                    throw new ParseException(kcodes, 0);
                }
            }
        }
    }
}

