/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nn.pp.rc.MonitorData;
import nn.pp.rc.MonitoringStream;

public class MonitoringOutputStream
extends DataOutputStream
implements MonitoringStream {
    OutputStream out;
    int count;

    public MonitoringOutputStream(OutputStream out) {
        super(out);
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        MonitoringOutputStream monitoringOutputStream = this;
        synchronized (monitoringOutputStream) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        MonitoringOutputStream monitoringOutputStream = this;
        synchronized (monitoringOutputStream) {
            this.count += len;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void writeUnsignedShort(int s) throws IOException {
        this.write(s >> 8 & 0xFF);
        this.write(s & 0xFF);
    }

    public final void writeUnsignedInt(long s) throws IOException {
        this.write((int)(s >> 24 & 0xFFL));
        this.write((int)(s >> 16 & 0xFFL));
        this.write((int)(s >> 8 & 0xFFL));
        this.write((int)(s & 0xFFL));
    }

    @Override
    public synchronized MonitorData getAndClearIn() {
        return new MonitorData(0);
    }

    @Override
    public synchronized int getAndClearOut() {
        int ret = this.count;
        this.count = 0;
        return ret;
    }
}

