/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rckbd;

import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import nn.pp.rckbd.KbdLayout;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.KeyTranslator;
import nn.pp.rckbd.SoftKbd;

public class KbdFactory {
    private static KbdFactory instance = null;
    private static final boolean debug = false;
    public static final String LAYOUT_CLASS = "nn.pp.rckbd.KbdLayout";
    public static final String TRANSLATOR_CLASS = "nn.pp.rckbd.KeyTranslator";
    public static final String MAPPING_CLASS = "nn.pp.rcsoftkbd.KbdMapping";
    private Hashtable i_layouts = new Hashtable();
    private Hashtable i_mappings = new Hashtable();
    private Hashtable i_trans = new Hashtable();
    private Vector p_layouts = new Vector();
    private Vector p_mappings;
    private Vector p_trans;
    public static URL applet_codebase;

    public static KbdFactory getInstance() {
        if (null == instance) {
            instance = new KbdFactory();
        }
        return instance;
    }

    protected KbdFactory() {
        this.p_layouts.addElement("pc104");
        this.p_layouts.addElement("pc109");
        this.p_layouts.addElement("Mac");
        this.p_mappings = new Vector();
        this.p_mappings.addElement(Locale.US);
        this.p_mappings.addElement(Locale.UK);
        this.p_mappings.addElement(Locale.GERMANY);
        this.p_mappings.addElement(new Locale("de", "CH"));
        this.p_mappings.addElement(Locale.FRANCE);
        this.p_mappings.addElement(Locale.ITALY);
        this.p_mappings.addElement(Locale.JAPAN);
        this.p_mappings.addElement(new Locale("es", "ES"));
        this.p_mappings.addElement(new Locale("pt", "PT"));
        this.p_mappings.addElement(new Locale("iw", "IL"));
        this.p_mappings.addElement(new Locale("ru", "RU"));
        this.p_mappings.addElement(new Locale("fi", "FI"));
        this.p_mappings.addElement(new Locale("sv", "SE"));
        this.p_mappings.addElement(new Locale("no", "NO"));
        this.p_mappings.addElement(new Locale("da", "DK"));
        this.p_mappings.addElement(new Locale("fr", "BE"));
        this.p_mappings.addElement(new Locale("nl", "BE"));
        this.p_trans = new Vector();
        this.p_trans.addElement(Locale.US);
        this.p_trans.addElement(Locale.GERMANY);
        this.p_trans.addElement(new Locale("de", "CH"));
        this.p_trans.addElement(Locale.FRANCE);
        this.p_trans.addElement(Locale.JAPAN);
        this.p_trans.addElement(new Locale("fr", "CH"));
        this.p_trans.addElement(Locale.UK);
        this.p_trans.addElement(new Locale("sv", "SE"));
        this.p_trans.addElement(new Locale("no", "NO"));
        this.p_trans.addElement(new Locale("fr", "BE"));
        this.p_trans.addElement(new Locale("nl", "BE"));
    }

    protected KbdFactory(String[] whatever) {
        this();
    }

    public KbdLayout getKbdLayout(String layout) {
        return (KbdLayout)this.getResource(this.i_layouts, LAYOUT_CLASS, layout);
    }

    public Object[] getKbdLayoutNames() {
        return this.toArray(this.p_layouts);
    }

    public Object getKbdMapping(String layout, Locale mapping) {
        return this.getLayoutResource(this.i_mappings, MAPPING_CLASS, layout, mapping.toString());
    }

    public Object[] getKbdMappingNames() {
        return this.toArray(this.p_mappings);
    }

    public KeyTranslator getKeyTranslator(String layout, Locale trans) {
        return (KeyTranslator)this.getLayoutResource(this.i_trans, TRANSLATOR_CLASS, layout, trans.toString());
    }

    public Object[] getKbdTranslatorNames() {
        return this.toArray(this.p_trans);
    }

    public SoftKbd getSoftKbd(KeyEventHandler keh, Locale mapping, String boardname, boolean interactive) {
        SoftKbd kbd = null;
        try {
            kbd = (SoftKbd)Class.forName("nn.pp.rcsoftkbd.SoftKbdImpl").newInstance();
            kbd.init(keh, mapping, boardname, interactive);
        }
        catch (Exception e) {
            System.err.println(" KbdFactory: ERROR: getSoftKbd: " + e);
            kbd = null;
            e.printStackTrace();
        }
        return kbd;
    }

    private Object getLayoutResource(Hashtable h, String classbase, String layout, String name) {
        String s = layout + "_" + name;
        Object r = h.get(s);
        if (null == r) {
            r = this.loadResource(classbase + s);
            if (null == r) {
                r = this.getResource(h, classbase, name);
            }
            h.put(s, r);
        }
        return r;
    }

    private Object getResource(Hashtable h, String classbase, String name) {
        Object r = h.get(name);
        if (null == r) {
            r = this.loadResource(classbase + "_" + name);
            h.put(name, r);
        }
        return r;
    }

    private Object loadResource(String name) {
        Object o;
        block2: {
            o = null;
            try {
                o = Class.forName(name).newInstance();
            }
            catch (Exception e) {
                int i = name.lastIndexOf(95);
                if (i <= 0) break block2;
                o = this.loadResource(name.substring(0, i));
            }
        }
        return o;
    }

    private Object[] toArray(Vector v) {
        Object[] os = new Object[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            os[i] = v.elementAt(i);
        }
        return os;
    }
}

