/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rckbd;

import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import nn.pp.rc.JVMVersionInfo;

public abstract class KeyTranslatorBase {
    private Hashtable codetable = null;
    private Hashtable chartable = null;
    private Vector initcode = new Vector();
    private Vector initchar = new Vector();
    private J14EventStuff j14stuff = null;

    public KeyTranslatorBase() {
        if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
            this.j14stuff = new J14EventStuff();
        }
    }

    public Short translateKeyEvent(KeyEvent evt) {
        char c;
        Short r;
        if (null == this.codetable) {
            this.createTranstables();
        }
        if ((r = (Short)this.chartable.get(new Character(c = evt.getKeyChar()))) == null) {
            r = (Short)this.codetable.get(new Integer(evt.getKeyCode()));
        }
        if (r != null && this.j14stuff != null && this.j14stuff.getKeyLocation(evt) == 3) {
            switch (r.intValue()) {
                case 55: {
                    r = new Short(57);
                    break;
                }
                case 41: {
                    r = new Short(53);
                    break;
                }
                case 54: {
                    r = new Short(58);
                }
            }
        }
        return r;
    }

    protected void addKeyTranslation(int[][] translations) {
        this.initcode.addElement(translations);
    }

    protected void addCharTranslation(int[][] translations) {
        this.initchar.addElement(translations);
    }

    public abstract Locale getLocale();

    private void createTranstables() {
        int k;
        int[][] t;
        int i;
        this.codetable = new Hashtable();
        this.chartable = new Hashtable();
        for (i = 0; i < this.initcode.size(); ++i) {
            t = (int[][])this.initcode.elementAt(i);
            for (k = 0; k < t.length; ++k) {
                this.codetable.put(new Integer(t[k][0]), new Short((short)t[k][1]));
            }
        }
        for (i = 0; i < this.initchar.size(); ++i) {
            t = (int[][])this.initchar.elementAt(i);
            for (k = 0; k < t.length; ++k) {
                this.chartable.put(new Character((char)t[k][0]), new Short((short)t[k][1]));
            }
        }
        this.initcode = null;
        this.initchar = null;
    }

    public class J14EventStuff {
        int getKeyLocation(KeyEvent kev) {
            return kev.getKeyLocation();
        }
    }
}

