/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.xml;

import com.sun.istack.internal.Nullable;
import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.ContextClassloaderLocal;
import com.sun.xml.internal.ws.util.xml.NamedNodeMapIterator;
import com.sun.xml.internal.ws.util.xml.NodeListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlUtil {
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    static final ContextClassloaderLocal<TransformerFactory> transformerFactory = new ContextClassloaderLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() throws Exception {
            return TransformerFactory.newInstance();
        }
    };
    static final ContextClassloaderLocal<SAXParserFactory> saxParserFactory = new ContextClassloaderLocal<SAXParserFactory>(){

        @Override
        protected SAXParserFactory initialValue() throws Exception {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory;
        }
    };
    public static final ErrorHandler DRACONIAN_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException sAXParseException) {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    };

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getAttributeOrNull(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string2, string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, QName qName) {
        Attr attr = element.getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static Iterator getAllChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Iterator getAllAttributes(Element element) {
        return new NamedNodeMapIterator(element.getAttributes());
    }

    public static List<String> parseTokenList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String getTextForNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuffer.append(node2.getNodeValue());
                continue;
            }
            if (node2 instanceof EntityReference) {
                String string = XmlUtil.getTextForNode(node2);
                if (string == null) {
                    return null;
                }
                stringBuffer.append(string);
                continue;
            }
            return null;
        }
        return stringBuffer.toString();
    }

    public static InputStream getUTF8Stream(String string) {
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayBuffer, "utf-8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            return byteArrayBuffer.newInputStream();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should not happen");
        }
    }

    public static Transformer newTransformer() {
        try {
            return transformerFactory.get().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Unable to create a JAXP transformer");
        }
    }

    public static <T extends Result> T identityTransform(Source source, T t) throws TransformerException, SAXException, ParserConfigurationException, IOException {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            TransformerHandler transformerHandler = ((SAXTransformerFactory)transformerFactory.get()).newTransformerHandler();
            transformerHandler.setResult(t);
            XMLReader xMLReader = saxParserFactory.get().newSAXParser().getXMLReader();
            xMLReader.setContentHandler(transformerHandler);
            xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, transformerHandler);
            xMLReader.parse(XmlUtil.toInputSource(streamSource));
        } else {
            XmlUtil.newTransformer().transform(source, t);
        }
        return t;
    }

    private static InputSource toInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        inputSource.setPublicId(streamSource.getPublicId());
        inputSource.setSystemId(streamSource.getSystemId());
        return inputSource;
    }

    public static EntityResolver createEntityResolver(@Nullable URL uRL) {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        Catalog catalog = catalogManager.getCatalog();
        try {
            if (uRL != null) {
                catalog.parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new ServerRtException("server.rt.err", new Object[]{iOException});
        }
        return XmlUtil.workaroundCatalogResolver(catalog);
    }

    public static EntityResolver createDefaultCatalogResolver() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Catalog catalog = catalogManager.getCatalog();
        try {
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources("META-INF/jax-ws-catalog.xml") : classLoader.getResources("META-INF/jax-ws-catalog.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                catalog.parseCatalog(uRL);
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        return XmlUtil.workaroundCatalogResolver(catalog);
    }

    private static CatalogResolver workaroundCatalogResolver(final Catalog catalog) {
        CatalogManager catalogManager = new CatalogManager(){

            @Override
            public Catalog getCatalog() {
                return catalog;
            }
        };
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setUseStaticCatalog(false);
        return new CatalogResolver(catalogManager);
    }
}

