/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.protocol.RedirHeader;
import com.ami.kvm.jviewer.Debug;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class IUSBHeader
extends RedirHeader {
    public String signature;
    public int major;
    public int minor;
    public int packetHeaderLen;
    public int headerChecksum;
    public long dataPacketLen;
    public int serverCaps;
    public int deviceType;
    public int protocol;
    public int direction;
    public int deviceNumber;
    public int interfaceNumber;
    public byte[] clientData = new byte[2];
    public long sequenceNumber;
    public byte[] reserved = new byte[4];
    public static final int HEADER_LEN = 32;
    private static final int IUSB_MAJOR = 1;
    private static final int IUSB_MINOR = 0;

    public IUSBHeader() {
        this.headerLen = 32;
    }

    public static IUSBHeader createKeyboardHeader(int dataLen) {
        IUSBHeader header = new IUSBHeader();
        header.signature = "IUSB    ";
        header.packetHeaderLen = 32;
        header.major = 1;
        header.minor = 0;
        header.sequenceNumber = 0L;
        header.direction = 128;
        header.dataPacketLen = dataLen;
        header.deviceType = 48;
        header.deviceNumber = 2;
        header.interfaceNumber = 0;
        header.protocol = 16;
        return header;
    }

    public static IUSBHeader createMouseHeader(int dataLen) {
        IUSBHeader header = new IUSBHeader();
        header.signature = "IUSB    ";
        header.packetHeaderLen = 32;
        header.major = 1;
        header.minor = 0;
        header.sequenceNumber = 0L;
        header.direction = 128;
        header.dataPacketLen = dataLen;
        header.deviceType = 49;
        header.deviceNumber = 2;
        header.interfaceNumber = 1;
        header.protocol = 32;
        return header;
    }

    public static IUSBHeader createCDROMHeader(int dataLen) {
        IUSBHeader header = new IUSBHeader();
        header.signature = "IUSB    ";
        header.packetHeaderLen = 32;
        header.major = 1;
        header.minor = 0;
        header.sequenceNumber = 0L;
        header.direction = 128;
        header.dataPacketLen = dataLen;
        header.deviceType = 5;
        header.deviceNumber = 0;
        header.interfaceNumber = 0;
        header.protocol = 1;
        return header;
    }

    @Override
    public void read(ByteBuffer rawBuffer) throws RedirProtocolException, BufferUnderflowException {
        byte[] sigTemp = new byte[8];
        rawBuffer.get(sigTemp);
        this.signature = new String(sigTemp);
        if (!this.signature.equals("IUSB    ")) {
            Debug.out.dump(sigTemp);
            throw new RedirProtocolException("Invalid header signature");
        }
        this.major = rawBuffer.get() & 0xFF;
        this.minor = rawBuffer.get() & 0xFF;
        this.packetHeaderLen = rawBuffer.get() & 0xFF;
        this.headerChecksum = rawBuffer.get() & 0xFF;
        this.dataPacketLen = (long)rawBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        this.serverCaps = rawBuffer.get() & 0xFF;
        this.deviceType = rawBuffer.get() & 0xFF;
        this.protocol = rawBuffer.get() & 0xFF;
        this.direction = rawBuffer.get() & 0xFF;
        this.deviceNumber = rawBuffer.get() & 0xFF;
        this.interfaceNumber = rawBuffer.get() & 0xFF;
        rawBuffer.get(this.clientData);
        this.sequenceNumber = (long)rawBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        rawBuffer.get(this.reserved);
    }

    @Override
    public void write(ByteBuffer rawBuffer) {
        rawBuffer.put(this.signature.getBytes());
        rawBuffer.put((byte)(this.major & 0xFF));
        rawBuffer.put((byte)(this.minor & 0xFF));
        rawBuffer.put((byte)(this.packetHeaderLen & 0xFF));
        rawBuffer.put((byte)(this.headerChecksum & 0xFF));
        rawBuffer.putInt((int)(this.dataPacketLen & 0xFFFFFFFFFFFFFFFFL));
        rawBuffer.put((byte)(this.serverCaps & 0xFF));
        rawBuffer.put((byte)(this.deviceType & 0xFF));
        rawBuffer.put((byte)(this.protocol & 0xFF));
        rawBuffer.put((byte)(this.direction & 0xFF));
        rawBuffer.put((byte)(this.deviceNumber & 0xFF));
        rawBuffer.put((byte)(this.interfaceNumber & 0xFF));
        rawBuffer.put(this.clientData);
        rawBuffer.putInt((int)(this.sequenceNumber & 0xFFFFFFFFFFFFFFFFL));
        rawBuffer.put(this.reserved);
        int temp = 0;
        for (int i = 0; i < rawBuffer.limit(); ++i) {
            temp = temp + (rawBuffer.get(i) & 0xFF) & 0xFF;
        }
        rawBuffer.put(11, -((byte)(temp & 0xFF)));
    }
}

