/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DevicePanel
extends JPanel {
    public static final int DEVICE_TYPE_CDROM = 0;
    public static final int DEVICE_TYPE_FLOPPY = 1;
    private static final int DEFAULT_NUM_DRIVES = 1;
    private ButtonGroup m_deviceButtonGroup;
    private JRadioButton[] m_deviceButtons;
    public JButton m_browseButton;
    private JTextField m_imagePath;
    private int m_deviceType;

    public DevicePanel(String[] driveList, int deviceType) {
        super(new GridLayout(driveList != null && driveList.length > 1 ? driveList.length + 1 : 2, 1, 0, 0));
        int totalDrives = driveList != null ? driveList.length + 1 : 1;
        this.m_deviceType = deviceType;
        this.m_deviceButtons = new JRadioButton[totalDrives];
        this.m_deviceButtonGroup = new ButtonGroup();
        this.m_deviceButtons[0] = new JRadioButton(deviceType == 0 ? "ISO Image" : "Floppy Image");
        this.m_deviceButtons[0].setBackground(Color.WHITE);
        this.m_deviceButtonGroup.add(this.m_deviceButtons[0]);
        this.m_deviceButtons[0].setSelected(true);
        int r_ix = 1;
        int d_ix = 0;
        while (r_ix < totalDrives) {
            this.m_deviceButtons[r_ix] = new JRadioButton(driveList[d_ix]);
            this.m_deviceButtons[r_ix].setBackground(Color.WHITE);
            this.m_deviceButtonGroup.add(this.m_deviceButtons[r_ix]);
            ++r_ix;
            ++d_ix;
        }
        JPanel panelImage = new JPanel(new BorderLayout(2, 0));
        panelImage.setBackground(Color.WHITE);
        this.m_imagePath = new JTextField(15);
        this.m_imagePath.setBorder(null);
        this.m_browseButton = new JButton(LocaleStrings.GetString("A_1_DP"));
        panelImage.add((Component)this.m_deviceButtons[0], "West");
        panelImage.add((Component)this.m_imagePath, "Center");
        panelImage.add((Component)this.m_browseButton, "East");
        this.add(panelImage);
        for (int r_ix2 = 1; r_ix2 < totalDrives; ++r_ix2) {
            this.add(this.m_deviceButtons[r_ix2]);
        }
        this.setBackground(Color.WHITE);
    }

    public boolean isImageSelected() {
        return this.m_deviceButtons[0].getModel() == this.m_deviceButtonGroup.getSelection();
    }

    public void setImagePath(String path) {
        this.m_imagePath.setText(path);
    }

    public String getImagePath() {
        return this.m_imagePath.getText();
    }

    public String selectedDeviceString() {
        Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != this.m_deviceButtonGroup.getSelection()) continue;
            return b.getText();
        }
        return "";
    }

    public void disableAll() {
        for (int i = 0; i < this.m_deviceButtons.length; ++i) {
            this.m_deviceButtons[i].setEnabled(false);
        }
        this.m_browseButton.setEnabled(false);
        this.m_imagePath.setEnabled(false);
    }

    public void enableAll() {
        for (int i = 0; i < this.m_deviceButtons.length; ++i) {
            this.m_deviceButtons[i].setEnabled(true);
        }
        this.m_browseButton.setEnabled(true);
        this.m_imagePath.setEnabled(true);
    }

    public void SelectRadioButton(String strRedirectedDevice) {
        JRadioButton b;
        Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
        while (e.hasMoreElements()) {
            b = (JRadioButton)e.nextElement();
            if (!b.getText().equals(strRedirectedDevice)) continue;
            b.setSelected(true);
            return;
        }
        e = this.m_deviceButtonGroup.getElements();
        if (e.hasMoreElements()) {
            b = (JRadioButton)e.nextElement();
            b.setSelected(true);
            this.m_imagePath.setText(strRedirectedDevice);
        }
    }

    public void SelectRadioButton(int nRedirectedDevice) {
        if (nRedirectedDevice >= 0 && nRedirectedDevice < this.m_deviceButtonGroup.getButtonCount()) {
            Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
            int counter = 0;
            while (e.hasMoreElements()) {
                JRadioButton b = (JRadioButton)e.nextElement();
                if (counter == nRedirectedDevice) {
                    b.setSelected(true);
                    return;
                }
                ++counter;
            }
        }
    }
}

