/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.video;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.kvmpkts.FrameHdr;
import com.ami.kvm.jviewer.video.VSCDecoder;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class JVVideo {
    JViewerApp app;
    public static final int MAX_X_RESOLUTION = 1500;
    public static final int MAX_Y_RESOLUTION = 1500;
    public static final int STATUS_BLANK_SCREEN_NORMAL = 0;
    public static final int STATUS_BLANK_SCREEN_POWER_OFF = 1;
    public static final int STATUS_BLANK_SCREEN_IN_POST = 2;
    private Timer m_frTmr;
    private int m_frameRate;
    private JViewerView m_view;
    private short[] m_ImageBuff_USHORT;
    private byte[] m_ImageBuff_BYTE;
    private FrameHdr m_frameHdr;
    private ByteBuffer m_qcompByteBuf;
    static int frame_count = 0;
    Vector<Rectangle> m_RegionVector;
    public short[] m_LRLEBuff_USHORT;
    public byte[] m_LRLEBuff_BYTE;
    public boolean m_IsHostPoweredOff = false;
    public boolean m_IsPostEntered = false;
    public boolean firsttime = true;

    public JVVideo(JViewerApp app) {
        this.app = app;
        this.m_view = app.getRCView();
        this.m_ImageBuff_USHORT = this.m_view.imageMemory();
        this.m_ImageBuff_BYTE = this.m_view.imageMemory_ByteArray();
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        byte[] buf = new byte[4500000];
        this.m_qcompByteBuf = ByteBuffer.wrap(buf);
        this.m_frameRate = 0;
        this.m_frTmr = new Timer();
        this.m_frTmr.schedule((TimerTask)new FrameRateTask(), 0L, 1000L);
        this.m_LRLEBuff_USHORT = new short[2250000];
        this.m_LRLEBuff_BYTE = new byte[2250000];
        this.m_RegionVector = new Vector();
    }

    public void onNewFrame(ByteBuffer frameByteBuf) {
        ++this.m_frameRate;
        this.m_frameHdr = FrameHdr.set(frameByteBuf);
        this.setM_frameHdr(this.m_frameHdr);
        int remaining_height = this.m_frameHdr.resY % 16;
        if (remaining_height != 0) {
            remaining_height = 16 - remaining_height;
        }
        this.m_frameHdr.resY = (short)(this.m_frameHdr.resY + remaining_height);
        if (this.firsttime) {
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            int resolY = this.m_frameHdr.resY;
            short resolX = this.m_frameHdr.resX;
            if (resolY == 608) {
                resolY = 600;
            }
            if (sd.height == resolY && sd.width == resolX) {
                this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
            } else {
                if (this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                    this.app.OnVideoFullScreen(false);
                }
                this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
            }
            this.firsttime = false;
        }
        if (this.m_view.viewWidth() != this.m_frameHdr.resX || this.m_view.viewHeight() != this.m_frameHdr.resY || this.m_view.m_current_color_mode != this.m_frameHdr.color_mode) {
            this.onResolutionChange();
        }
        this.m_RegionVector.clear();
        VSCDecoder.UnCompress(this.m_ImageBuff_USHORT, this.m_ImageBuff_BYTE, this.m_LRLEBuff_USHORT, this.m_LRLEBuff_BYTE, frameByteBuf, this.m_frameHdr, this.m_RegionVector);
        if (remaining_height != 0) {
            for (int i = 0; i < this.m_RegionVector.size(); ++i) {
                Rectangle rect = this.m_RegionVector.get(i);
                if (rect != null && rect.y + rect.height > this.m_frameHdr.resY - remaining_height) {
                    if (this.m_frameHdr.color_mode == 8) {
                        Arrays.fill(this.m_ImageBuff_USHORT, this.m_frameHdr.resX * (this.m_frameHdr.resY - remaining_height), this.m_frameHdr.resX * this.m_frameHdr.resY - 1, (short)0);
                    } else {
                        Arrays.fill(this.m_ImageBuff_BYTE, this.m_frameHdr.resX * (this.m_frameHdr.resY - remaining_height), this.m_frameHdr.resX * this.m_frameHdr.resY - 1, (byte)0);
                    }
                    rect.height = remaining_height + 4;
                }
                this.m_view.repaint(rect);
            }
        } else {
            for (int i = 0; i < this.m_RegionVector.size(); ++i) {
                this.m_view.repaint(this.m_RegionVector.get(i));
            }
        }
        this.m_RegionVector.clear();
    }

    public void onResolutionChange() {
        Debug.out.println("Resolution change " + this.m_frameHdr.resX + ":" + this.m_frameHdr.resY);
        this.m_view.setRCView(this.m_frameHdr.resX, this.m_frameHdr.resY, this.m_frameHdr.color_mode);
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        int resolY = this.m_frameHdr.resY;
        short resolX = this.m_frameHdr.resX;
        if (resolY == 608) {
            resolY = 600;
        }
        if (sd.height == resolY && sd.width == resolX) {
            this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
        } else {
            if (this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                this.app.OnVideoFullScreen(false);
            }
            this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
        }
        if (sd.height > this.m_frameHdr.resY || sd.width > this.m_frameHdr.resX || sd.height <= this.m_frameHdr.resY || sd.width <= this.m_frameHdr.resX) {
            // empty if block
        }
        this.m_ImageBuff_USHORT = this.m_view.imageMemory();
        this.m_ImageBuff_BYTE = this.m_view.imageMemory_ByteArray();
        if (this.m_ImageBuff_BYTE != null) {
            Debug.out.println("image array byte length " + this.m_ImageBuff_BYTE.length);
        }
        System.gc();
    }

    public void onBlankScreen(short status) {
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        this.m_view.repaint();
        if (status == 2) {
            this.m_IsPostEntered = true;
        } else if (status == 1) {
            this.m_IsHostPoweredOff = true;
        } else {
            this.m_IsHostPoweredOff = false;
            this.m_IsPostEntered = false;
        }
    }

    public void reset() {
        if (this.m_ImageBuff_USHORT != null) {
            Arrays.fill(this.m_ImageBuff_USHORT, (short)0);
        }
        if (this.m_ImageBuff_BYTE != null) {
            Arrays.fill(this.m_ImageBuff_BYTE, (byte)0);
        }
        this.m_view.repaint();
        this.m_frTmr.cancel();
        this.app.setAppWndLabel("0 fps");
    }

    public FrameHdr getM_frameHdr() {
        return this.m_frameHdr;
    }

    public void setM_frameHdr(FrameHdr hdr) {
        this.m_frameHdr = hdr;
    }

    public void clearBuffer() {
        this.m_ImageBuff_USHORT = null;
        this.m_ImageBuff_BYTE = null;
        this.m_LRLEBuff_USHORT = null;
        this.m_LRLEBuff_BYTE = null;
        if (this.m_qcompByteBuf != null) {
            this.m_qcompByteBuf.clear();
            this.m_qcompByteBuf = null;
        }
    }

    class FrameRateTask
    extends TimerTask {
        Dimension Client_System_prev;

        FrameRateTask() {
        }

        @Override
        public void run() {
            Dimension Client_System = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.Client_System_prev == null) {
                this.Client_System_prev = Client_System;
            }
            if (Client_System.width != this.Client_System_prev.width || Client_System.height != this.Client_System_prev.height) {
                Debug.out.println("Resolution change in client");
                Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
                int resolY = ((JVVideo)JVVideo.this).m_frameHdr.resY;
                short resolX = ((JVVideo)JVVideo.this).m_frameHdr.resX;
                if (resolY == 608) {
                    resolY = 600;
                }
                if (sd.height == resolY && sd.width == resolX) {
                    JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(true);
                } else {
                    if (JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").isSelected()) {
                        JVVideo.this.app.OnVideoFullScreen(false);
                    }
                    JVVideo.this.app.getJVMenu().getMenuItem("VideoFullScreen").setEnabled(false);
                }
                if (Client_System.height > ((JVVideo)JVVideo.this).m_frameHdr.resY || Client_System.width > ((JVVideo)JVVideo.this).m_frameHdr.resX || Client_System.height <= ((JVVideo)JVVideo.this).m_frameHdr.resY || Client_System.width <= ((JVVideo)JVVideo.this).m_frameHdr.resX) {
                    // empty if block
                }
            }
            this.Client_System_prev = Client_System;
            if (JVVideo.this.m_frameRate == 0) {
                if (!JVVideo.this.m_IsPostEntered && JVVideo.this.m_IsHostPoweredOff) {
                    // empty if block
                }
            } else {
                JVVideo.this.app.setAppWndLabel(JVVideo.this.m_frameRate + " fps");
                JVVideo.this.m_IsHostPoweredOff = false;
                JVVideo.this.m_IsPostEntered = false;
            }
            JVVideo.this.m_frameRate = 0;
        }
    }
}

