/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.util.ArrayList;

public class IPMINVMECommand
extends IPMICommand {
    int aocSize = 3;
    int slotSize = 12;
    int groupSize = 4;

    public IPMINVMECommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getPCIeSSDParameterCommand(byte aoc, byte slot, byte action, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 0, aoc, slot, action, group, 0, 114};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPCIeSSDParameterCommand(byte aoc, byte slot, byte action, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 1, aoc, slot, action, group};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getEjectFlagCommand(byte aoc, byte group) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{108, 0, aoc, 0, 2, group};
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] getEjectFlagArray(byte aoc, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getEjectFlagCommand(aoc, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPCIeSSDParameterCommand failed (NVME)");
    }

    public byte[] getNVMEAOCMetaData(byte aoc, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getPCIeSSDParameterCommand(aoc, (byte)0, (byte)0, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPCIeSSDParameterCommand failed (NVME)");
    }

    public byte[] getNVMERaw(byte aoc, byte slot, byte group) throws IPMIException {
        IPMIMessage resMessage = this.getPCIeSSDParameterCommand(aoc, slot, (byte)1, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPCIeSSDParameterCommand failed (NVME)");
    }

    public byte[] setLocate(byte aoc, byte slot, byte action, byte group) throws IPMIException {
        IPMIMessage resMessage = this.setPCIeSSDParameterCommand(aoc, slot, action, group);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setPCIeSSDParameterCommand failed (NVME)");
    }

    public boolean isEjected(int aoc, int slot, int group) throws IPMIException {
        byte[] raw = this.getEjectFlagArray((byte)aoc, (byte)group);
        int ejectStatus = ByteUtility.twoBytesToIntLSB(raw, 4);
        return (ejectStatus & 1 << slot) >= 1;
    }

    public ArrayList<NVMEAOCInfo> getAll() throws IPMIException {
        ArrayList<NVMEAOCInfo> nvmeAOCInfos = new ArrayList<NVMEAOCInfo>();
        try {
            byte[] raw = this.getNVMEAOCMetaData((byte)0, (byte)0);
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < this.aocSize; ++i) {
            byte[] raw = this.getNVMEAOCMetaData((byte)i, (byte)0);
            if (!this.checkIfCardPresentedFromRawData(raw)) continue;
            NVMEAOCInfo nvmeAOCInfo = new NVMEAOCInfo();
            nvmeAOCInfo.fromRaw((byte)i, raw);
            for (int k = 0; k < this.groupSize; ++k) {
                raw = this.getNVMEAOCMetaData((byte)i, (byte)k);
                AOCGroupInfo aocGroupInfo = new AOCGroupInfo();
                aocGroupInfo.fromRaw(raw);
                aocGroupInfo.group = (byte)k;
                nvmeAOCInfo.aocGroups.add(aocGroupInfo);
                for (int j = 0; j < this.slotSize; ++j) {
                    byte[] nvmeRaw = this.getNVMERaw((byte)i, (byte)j, (byte)k);
                    aocGroupInfo.addVDP((byte)j, nvmeRaw);
                }
            }
            nvmeAOCInfos.add(nvmeAOCInfo);
        }
        return nvmeAOCInfos;
    }

    private boolean checkIfCardPresentedFromRawData(byte[] raw) {
        return raw[1] == 1;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("172.31.32.46");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMINVMECommand ipmiINVMECommand = new IPMINVMECommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiINVMECommand);
        if (sessionController == null) {
            return;
        }
        try {
            ArrayList<NVMEAOCInfo> nvmeAOCInfos = ipmiINVMECommand.getAll();
            for (int i = 0; i < nvmeAOCInfos.size(); ++i) {
                System.out.println(nvmeAOCInfos.get(i).toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }

    public class VPD {
        byte group;
        byte slot;
        int locateStatus;
        int ssdPresentStatus;
        byte totalDataLength;
        byte data2;
        byte[] classCode = new byte[3];
        byte[] id = new byte[2];
        byte[] serialNumber = new byte[20];
        byte[] modelNumber = new byte[40];
        byte pciePort0MaxLinkSpeed;
        byte pciePort0MaxLinkWidth;
        byte pciePort1MaxLinkSpeed;
        byte pciePort1MaxLinkWidth;
        byte iniPower;
        byte maxPower;
        byte ssdTemp;
        byte[] capListPointer = new byte[2];

        public boolean isPresented() {
            return (this.ssdPresentStatus & 1 << this.slot) >= 1;
        }

        public boolean isLocated() {
            return (this.locateStatus & 1 << this.slot) >= 1;
        }

        public String indexLinkSpeed(byte index) {
            if (index == 1) {
                return "2.5 GT/s";
            }
            if (index == 2) {
                return "5.0 GT/s";
            }
            if (index == 3) {
                return "8.0 GT/s";
            }
            return "N/A";
        }

        public String indexLinkSpeed_old(byte index) {
            int value = 0;
            for (int i = 7; i >= 0; --i) {
                if ((index & (byte)(1 << i)) <= 0) continue;
                value = (byte)(1 << i);
                break;
            }
            if (value == 1) {
                return "2.5 GT/s";
            }
            if (value == 2) {
                return "5.0 GT/s";
            }
            if (value == 4) {
                return "8.0 GT/s";
            }
            return "Unknown";
        }

        public String indexLinkWidth(byte index) {
            if (index == 1) {
                return "x1";
            }
            if (index == 2) {
                return "x2";
            }
            if (index == 4) {
                return "x4";
            }
            if (index == 8) {
                return "x8";
            }
            return "Unknown";
        }

        public void fromRaw(byte aSlot, int locateStatus, int ssdPresentStatus, byte[] raw) {
            int index = 0;
            this.slot = aSlot;
            this.locateStatus = locateStatus;
            this.ssdPresentStatus = ssdPresentStatus;
            this.totalDataLength = raw[index];
            System.arraycopy(raw, ++index, this.classCode, 0, this.classCode.length);
            System.arraycopy(raw, index += this.classCode.length, this.id, 0, this.id.length);
            System.arraycopy(raw, index += this.id.length, this.serialNumber, 0, this.serialNumber.length);
            System.arraycopy(raw, index += this.serialNumber.length, this.modelNumber, 0, this.modelNumber.length);
            this.pciePort0MaxLinkSpeed = raw[index += this.modelNumber.length];
            this.pciePort0MaxLinkWidth = raw[++index];
            this.pciePort1MaxLinkSpeed = raw[++index];
            this.pciePort1MaxLinkWidth = raw[++index];
            this.iniPower = raw[++index];
            this.maxPower = raw[index += 3];
            System.arraycopy(raw, index += 3, this.capListPointer, 0, this.capListPointer.length);
            index += this.capListPointer.length;
            this.ssdTemp = raw[103];
            byte temp = this.id[0];
            this.id[0] = this.id[1];
            this.id[1] = temp;
        }

        public byte getSlot() {
            return this.slot;
        }

        public int getRealSlot() {
            return this.group * 12 + this.slot;
        }

        public String toFormatedHeader() {
            String formatTemplate = " %-30s | %25s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatTemplate, "Item", "Value"));
            header.append(String.format(formatTemplate, "----", "-----"));
            return header.toString();
        }

        public String toFormatedString() {
            String f = " %-30s | %25s \n";
            StringBuffer fStr = new StringBuffer();
            fStr.append(String.format(f, "Slot", this.getRealSlot()));
            fStr.append(String.format(f, "Located", this.isLocated() ? "Yes" : "No"));
            fStr.append(String.format(f, "OOB Temp.", this.ssdTemp + " C"));
            fStr.append(String.format(f, "Class Code", ByteUtility.bytesToHex(this.classCode).trim()));
            fStr.append(String.format(f, "ID", ByteUtility.bytesToHex(this.id).trim()));
            fStr.append(String.format(f, "Serial Number", new String(this.serialNumber).trim()));
            fStr.append(String.format(f, "Model Number", new String(this.modelNumber).trim()));
            fStr.append(String.format(f, "Port0 Max Link Speed", this.indexLinkSpeed(this.pciePort0MaxLinkSpeed)));
            fStr.append(String.format(f, "Port0 Max Link Width", this.indexLinkWidth(this.pciePort0MaxLinkWidth)));
            fStr.append(String.format(f, "Port1 Max Link Speed", this.indexLinkSpeed(this.pciePort1MaxLinkSpeed)));
            fStr.append(String.format(f, "Port1 Max Link Width", this.indexLinkWidth(this.pciePort1MaxLinkWidth)));
            fStr.append(String.format(f, "Init Power Requirement", this.iniPower + " Watts"));
            fStr.append(String.format(f, "Max  Power Requirement", this.maxPower + " Watts"));
            return fStr.toString();
        }
    }

    public class NVMEAOCInfo {
        public byte aoc;
        public byte i2c;
        public byte isCardPresented;
        public byte[] firmwareInfo = new byte[11];
        public ArrayList<AOCGroupInfo> aocGroups = new ArrayList();

        public boolean isCardPresented() {
            return this.isCardPresented > 0;
        }

        public void fromRaw(byte aoc, byte[] raw) {
            this.aoc = aoc;
            this.i2c = raw[0];
            this.isCardPresented = raw[1];
            System.arraycopy(raw, 6, this.firmwareInfo, 0, raw.length - 6);
        }

        public String toString() {
            String result = "";
            result = result + "[AOC Number:" + this.aoc + "] ";
            result = result + "[Firmware Info:" + ByteUtility.byteToHex(this.firmwareInfo[0]) + " " + ByteUtility.byteToHex(this.firmwareInfo[1]) + "]";
            for (int k = 0; k < IPMINVMECommand.this.groupSize; ++k) {
                boolean emptyData = true;
                ArrayList<VPD> vpds = this.aocGroups.get((int)k).vpds;
                for (int i = 0; i < vpds.size(); ++i) {
                    try {
                        if (!vpds.get(i).isPresented() || IPMINVMECommand.this.isEjected(this.aoc, vpds.get((int)i).slot, k)) continue;
                        result = result + "\n";
                        result = result + vpds.get(i).toFormatedHeader();
                        result = result + vpds.get(i).toFormatedString();
                        emptyData = false;
                        continue;
                    }
                    catch (IPMIException e) {
                        e.printStackTrace();
                    }
                }
                if (emptyData) continue;
                result = result + "--------------------------End of Group " + k + "-------------------\n";
            }
            return result;
        }
    }

    public class AOCGroupInfo {
        public byte group;
        public int locateStatus;
        public int ssdPresentStatus;
        public ArrayList<VPD> vpds = new ArrayList();

        public void fromRaw(byte[] raw) {
            this.locateStatus = ByteUtility.twoBytesToIntLSB(raw, 2);
            this.ssdPresentStatus = ByteUtility.twoBytesToIntLSB(raw, 4);
        }

        public void addVDP(byte slot, byte[] raw) {
            VPD vpd = new VPD();
            vpd.fromRaw(slot, this.locateStatus, this.ssdPresentStatus, raw);
            vpd.group = this.group;
            this.vpds.add(vpd);
        }

        public boolean isMatchSerialNumber(String serial) {
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial)) continue;
                return true;
            }
            return false;
        }

        public VPD getMatchVPD(String serial) {
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial)) continue;
                return this.vpds.get(i);
            }
            return null;
        }

        public int getOOBSlot(String serial) {
            for (int i = 0; i < this.vpds.size(); ++i) {
                String s;
                if (!this.vpds.get(i).isPresented()) continue;
                if (serial.charAt(0) == 'S' && serial.charAt(4) == 'N') {
                    char[] data = serial.toCharArray();
                    if (data[3] == '0') {
                        data[3] = 79;
                    }
                    serial = new String(data);
                }
                if (!(s = new String(this.vpds.get((int)i).serialNumber).trim()).equals(serial)) continue;
                return i;
            }
            return -1;
        }
    }
}

