/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B8DTG_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String GPU1_TEMP = "GPU1 Temp";
    public static final String GPU2_TEMP = "GPU2 Temp";
    public static final String CPU1_DIMM_VOLTAGE = "CPU1 DIMM voltage";
    public static final String CPU2_DIMM_VOLTAGE = "CPU2 DIMM voltage";
    private byte gpu1Temp;
    private byte gpu2Temp;
    private byte gpu1TempLimit;
    private byte gpu2TempLimit;
    private byte cpu1DIMMVoltage;
    private byte cpu2DIMMVoltage;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.isPECI = raw[2];
        this.remoteCPU1Temp = raw[3];
        this.remoteCPU2Temp = raw[4];
        this.gpu1Temp = raw[5];
        this.gpu2Temp = raw[6];
        this.systemTemp = raw[7];
        this.cpu1CoreVoltage = raw[8];
        this.cpu2CoreVoltage = raw[9];
        this.v1p2 = raw[10];
        this.cpu1DIMMVoltage = raw[11];
        this.cpu2DIMMVoltage = raw[12];
        this.v3p3 = raw[13];
        this.v12 = raw[14];
        this.v5 = raw[15];
        this.v5sb = raw[16];
        this.batteryVoltage = raw[17];
        this.gpu1TempLimit = raw[18];
        this.gpu2TempLimit = raw[19];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkGPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, GPU1_TEMP));
        }
        if (this.checkGPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, GPU2_TEMP));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "System Temp"));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkCPUVTT() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU VTT"));
        }
        if (this.checkCPU1DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_DIMM_VOLTAGE));
        }
        if (this.checkCPU2DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_DIMM_VOLTAGE));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        return failures;
    }

    public int checkGPU1Temp() {
        if (this.getGPU1Temp() == -127) {
            return 2;
        }
        if (this.getGPU1Temp() < this.getGPU1TempLimit()) {
            return 0;
        }
        return 1;
    }

    public byte getGPU1Temp() {
        return this.gpu1Temp;
    }

    public byte getGPU1TempLimit() {
        return this.gpu1TempLimit;
    }

    public int checkGPU2Temp() {
        if (this.getGPU2Temp() == -127) {
            return 2;
        }
        if (this.getGPU2Temp() < this.getGPU2TempLimit()) {
            return 0;
        }
        return 1;
    }

    public byte getGPU2Temp() {
        return this.gpu2Temp;
    }

    public byte getGPU2TempLimit() {
        return this.gpu2TempLimit;
    }

    public int checkCPU1DIMMVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() <= this.getCPU1DIMMVoltageLowLimit() || this.getCPU1DIMMVoltageFormula() >= this.getCPU1DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getCPU1DIMMVoltageFormula() {
        return (double)(this.cpu1DIMMVoltage & 0xFF) * 0.016;
    }

    public double getCPU1DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCPU1DIMMVoltageHighLimit() {
        return 1.65;
    }

    public int checkCPU2DIMMVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() <= this.getCPU2DIMMVoltageLowLimit() || this.getCPU2DIMMVoltageFormula() >= this.getCPU2DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getCPU2DIMMVoltageFormula() {
        return (double)(this.cpu2DIMMVoltage & 0xFF) * 0.016;
    }

    public double getCPU2DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCPU2DIMMVoltageHighLimit() {
        return 1.65;
    }

    @Override
    public double getCpu1CoreVoltageLowLimit() {
        return 0.8;
    }

    @Override
    public double getCpu2CoreVoltageLowLimit() {
        return 0.8;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A");
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A");
        this.addRaw(this.checkGPU1Temp(), GPU1_TEMP, this.showCandF(this.getGPU1Temp()), "N/A", "" + this.showCandF(this.getGPU1TempLimit()));
        this.addRaw(this.checkGPU2Temp(), GPU2_TEMP, this.showCandF(this.getGPU2Temp()), "N/A", "" + this.showCandF(this.getGPU2TempLimit()));
        this.addRaw(this.checkSystemTemp(), "System Temp", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCPUVTT(), "CPU VTT", this.d2StrV(this.getV1p2Formula()), this.d2StrV(this.getCPUVTTLowLimit()), this.d2StrV(this.getCPUVTTHighLimit()));
        this.addRaw(this.checkCPU1DIMMVoltage(), CPU1_DIMM_VOLTAGE, this.d2StrV(this.getCPU1DIMMVoltageFormula()), this.d2StrV(this.getCPU1DIMMVoltageLowLimit()), this.d2StrV(this.getCPU1DIMMVoltageHighLimit()));
        this.addRaw(this.checkCPU2DIMMVoltage(), CPU2_DIMM_VOLTAGE, this.d2StrV(this.getCPU2DIMMVoltageFormula()), this.d2StrV(this.getCPU2DIMMVoltageLowLimit()), this.d2StrV(this.getCPU2DIMMVoltageHighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), "5VSB", this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5sbLowLimit()), this.d2StrV(this.getV5sbHighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == 0 || this.getRemoteCPU1Temp() == 1 || this.getRemoteCPU1Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU1Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == 0 || this.getRemoteCPU2Temp() == 1 || this.getRemoteCPU2Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU2Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkGPU1Temp(), GPU1_TEMP, this.showCandF(this.getGPU1Temp()), "N/A", "" + this.showCandF(this.getGPU1TempLimit())));
        list.add(this.createTemperatureData(this.checkGPU2Temp(), GPU2_TEMP, this.showCandF(this.getGPU2Temp()), "N/A", "" + this.showCandF(this.getGPU2TempLimit())));
        list.add(this.createTemperatureData(this.checkSystemTemp(), "System Temp", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }
}

