/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;

public class NodeStatusInfo
extends AbstractModuleInfo {
    public byte present;
    public byte initialized;
    public byte error;
    public byte cpuUsage;
    public byte validIpBit;
    public byte validIpmbBit;
    public byte sendToCount;
    public byte[] reserved;
    public byte[] selReport;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.present = raw[index];
        this.initialized = raw[index];
        this.error = raw[index];
        this.cpuUsage = raw[index];
        this.validIpBit = raw[index];
        this.validIpmbBit = raw[index++];
        this.sendToCount = raw[index++];
        this.reserved = ByteUtility.getBytes(raw, index, 10);
        this.selReport = ByteUtility.getBytes(raw, index += 10, 4);
        index += 4;
    }

    public int getSelReport() {
        return ByteUtility.fourBytesToInt(this.selReport);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("present =" + this.present);
        sb.append("\npresent =" + this.isPresent());
        sb.append("\ninitialized =" + this.initialized());
        sb.append("\nerror =" + this.error());
        sb.append("\ncpuUsage =" + this.cpuUsage());
        sb.append("\nvalidIpBit =" + this.validIp());
        sb.append("\nvalidIpmbBit =" + this.validIpmb());
        sb.append("\nsendToCount =" + this.sendToCount);
        sb.append("\nreserved =" + ByteUtility.bytesToHex(this.reserved));
        sb.append("\nselReport =" + this.getSelReport());
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean isPresent() {
        return (byte)(this.present & 1) == 1;
    }

    public boolean initialized() {
        return (byte)(this.initialized & 2) == 2;
    }

    public byte error() {
        return (byte)(this.error & 0xC);
    }

    public byte cpuUsage() {
        return (byte)(this.cpuUsage & 0x30);
    }

    public boolean validIp() {
        return (byte)(this.validIpBit & 0x40) == 64;
    }

    public boolean validIpmb() {
        return (byte)(this.validIpmbBit & 0x80) == -128;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Blade", "M/S", "Status"));
        header.append(String.format(formatTemplate, "---", "---", "------"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.isPresent()) {
            return "";
        }
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "CMM " + this.getIndex();
        formatedString.append(String.format(formatTemplate, index, this.initialized(), this.reserved));
        return formatedString.toString();
    }
}

