/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractModuleInfo;

public class RedundantCMMInfo
extends AbstractModuleInfo {
    public byte location;
    public byte[] fwRevision;
    public byte[] fwBuiltTime;
    public byte[] mac;
    public byte fwUpdateStatus;
    public byte flashingPercent;

    @Override
    public void fromRaw(byte[] raw) {
        super.fromRaw(raw);
        int index = 0;
        this.location = raw[index];
        this.fwRevision = ByteUtility.getBytes(raw, ++index, 2);
        this.fwBuiltTime = ByteUtility.getBytes(raw, index += 2, 11);
        this.mac = ByteUtility.getBytes(raw, index += 11, 6);
        this.fwUpdateStatus = raw[index += 6];
        this.flashingPercent = raw[++index];
        ++index;
    }

    public String getVersion() {
        String versionString = Byte.toString(this.fwRevision[0]) + "." + Byte.toString(this.fwRevision[1]);
        return versionString;
    }

    public String getFWbuildTime() {
        String buildString = null;
        for (int i = 0; i < 11; ++i) {
            buildString = buildString + Byte.toString(this.fwBuiltTime[i]);
        }
        return buildString;
    }

    public String getMac() {
        String Mac2 = null;
        for (int i = 0; i < 6; ++i) {
            Mac2 = Mac2 + ByteUtility.byteToHex(this.mac[i]);
            if (i == 5) continue;
            Mac2 = Mac2 + ":";
        }
        return Mac2;
    }
}

