/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIAMIYAFUCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIFlashwCommand
extends SuperBladeCommand {
    int preserveConfig = 1;

    public void usage() {
        MOut.G(this).println("flashw <filename> [Preserve_opt]");
        MOut.G(this).println("Preserve option");
        MOut.G(this).println("0: Do not preserve config");
        MOut.G(this).println("1: Preserve config [deafult option]");
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("firmware filename is needed");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        if (this.parameters.length > 1) {
            String tempPreserveConfig = this.parameters[1];
            try {
                this.preserveConfig = Integer.parseInt(tempPreserveConfig);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println("Invalid preserve config value [0|1]");
                return false;
            }
            if (this.preserveConfig != 0 && this.preserveConfig != 1) {
                MOut.G(this).println("Invalid preserve config value [0|1]");
                return false;
            }
        }
        return true;
    }

    public boolean checkIfSupportedDevice() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        return IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMIAddOnGUID(guid) || IPMIMessagingCommand.isAMIOnBoardGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid);
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.checkIfSupportedDevice()) {
            MOut.G(this).println("Not a supported device");
            MOut.G(this).println("This command is used for updating X8 BMC firmware (*.ima)");
            this.statusCode = 153;
            return;
        }
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ipmiAMIYAFUCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        MOut.G(this).println("Start Time = " + LogUtil.getSystemDateTime());
        ipmiAMIYAFUCommand.setMOut(MOut.G(this));
        boolean result = ipmiAMIYAFUCommand.flashFlow(this.parameters[0], true, true, true, (byte)this.preserveConfig);
        MOut.G(this).println("Please wait for 1 minute ...");
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        MOut.G(this).println("End Time =" + LogUtil.getSystemDateTime());
        this.statusCode = result ? 0 : 149;
    }
}

