/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class IPMIOEMBackupCommand
extends SuperBladeCommand {
    String filename;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Please specify filename");
            return false;
        }
        this.filename = this.parameters[0];
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isEnc = true;
        boolean isList = false;
        if (this.parameters.length >= 2 && this.parameters[1].equalsIgnoreCase("noenc")) {
            isEnc = false;
        }
        if (this.parameters.length >= 3 && this.parameters[2].equalsIgnoreCase("list")) {
            isList = true;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = false;
        try {
            result = ipmiOEMCommand.isBackupAndRestoreFuncExist();
            if (!result) {
                MOut.G(this).println("Not a supported command");
                this.statusCode = 150;
                return;
            }
        }
        catch (Exception ex) {
            MOut.G(this).println("Not a supported command");
            this.statusCode = 150;
            return;
        }
        result = ipmiOEMCommand.backupConfiguration(new File(this.filename), isEnc);
        if (result) {
            if (isList) {
                this.printContent();
            } else if (isEnc) {
                MOut.G(this).println("done");
            } else {
                MOut.G(this).println("done (non-encrypt)");
            }
        } else {
            MOut.G(this).println("failed");
        }
        this.statusCode = result ? 0 : 149;
    }

    public void printContent() {
        try {
            String line;
            FileReader fr = new FileReader(this.filename);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null && line.length() != 0) {
                MOut.G(this).print(line + "\r\n");
            }
        }
        catch (FileNotFoundException ex) {
            MOut.G(this).println(ex.toString());
        }
        catch (IOException ioe) {
            MOut.G(this).println(ioe.toString());
        }
    }
}

