/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class IPMIOEMRestoreCommand
extends SuperBladeCommand {
    boolean isEnc = true;
    String filename;
    int restoreOption;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            String usage = "\nUsage: restore <filename> <option>\nFilename: configuration file for restoring\nOption <0>: restore all except MAC\nOption <1>: restore all except MAC, IP, Netmask and Gateway IP\n";
            MOut.G(this).println(usage);
            return false;
        }
        this.filename = this.parameters[0];
        try {
            this.restoreOption = Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("Do not support this option type:" + this.parameters[1]);
            return false;
        }
        if (this.restoreOption != 0 && this.restoreOption != 1) {
            MOut.G(this).println("Do not support this option type:" + this.parameters[1]);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean isEnc = true;
        if (this.parameters.length >= 3 && this.parameters[2].equalsIgnoreCase("noenc")) {
            isEnc = false;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = false;
        try {
            result = ipmiOEMCommand.isBackupAndRestoreFuncExist();
            if (!result) {
                MOut.G(this).println("Not a supported command");
                this.statusCode = 150;
                return;
            }
        }
        catch (Exception ex) {
            MOut.G(this).println("Not a supported command");
            this.statusCode = 150;
            return;
        }
        result = ipmiOEMCommand.restoreConfiguration(new File(this.filename), isEnc, (byte)this.restoreOption);
        if (result) {
            if (isEnc) {
                MOut.G(this).println("done");
            } else {
                MOut.G(this).println("done (non-encrypt)");
            }
        } else {
            MOut.G(this).println("failed");
        }
        this.statusCode = result ? 0 : 149;
    }
}

