/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SELTimeCommand
extends SuperBladeCommand {
    String dateTimeString = null;

    @Override
    public boolean preValidate() {
        this.dateTimeString = null;
        if (this.parameters != null && this.parameters[0] != null) {
            this.dateTimeString = this.parameters[0];
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.dateTimeString == null) {
            String selTime = ipmiSELCommand.getSELTimeWithFormat();
            MOut.G(this).println(selTime);
            this.statusCode = 0;
        } else {
            if (this.dateTimeString.length() != 12) {
                this.usage();
                this.statusCode = 147;
                return;
            }
            byte[] bdtAry = new byte[3];
            Date dt2 = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            sdf.applyPattern("yyyyMMddHHmm");
            try {
                dt2 = sdf.parse(this.dateTimeString);
            }
            catch (ParseException e) {
                this.usage();
                this.statusCode = 147;
                return;
            }
            long timeValue = dt2.getTime();
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, timeValue /= 1000L);
            System.arraycopy(tempAry, 0, bdtAry, 0, bdtAry.length);
            boolean b = ipmiSELCommand.setSELTime(tempAry);
            if (b) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Set SEL Time failed");
                this.statusCode = 149;
            }
        }
    }

    public void usage() {
        MOut.G(this).println("Date/Time format error.");
        MOut.G(this).println("");
        MOut.G(this).println("Format: YYYYMMDDhhmm  ex:201007161200 (2010/07/16 12:00)");
    }

    public static void main(String[] args) {
        int eData2 = -1;
        int eData3 = -1;
        byte bank_high = (byte)((eData2 >> 4) + 64 + (eData3 & 3) * 4);
        byte bank_low = (byte)((eData2 & 0xF) + 39);
        System.out.println("" + ((eData2 >> 4) + 64));
        System.out.println("" + (eData3 & 3) * 4);
        System.out.println("bank_high =" + bank_high);
        System.out.println("bank_low =" + bank_low);
        String loc = String.format("@DIMM%c%c(CPU%x)", bank_high, bank_low, (eData3 & 3) + 1);
        System.out.println("loc =" + loc);
    }
}

