/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class VRMUpdate3746Command
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 1;
        byte slaveAddr = 72;
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("Please specify the psf file path.");
        } else {
            ipmiHDDOEMCommand.setSensorPollingFlag(false);
            FileReader fr = new FileReader(this.parameters[0]);
            if (fr == null) {
                MOut.G(this).println("Open first file fail.");
                this.statusCode = 147;
                return;
            }
            FileReader fr2 = new FileReader(this.parameters[1]);
            if (fr2 == null) {
                MOut.G(this).println("Open second file fail.");
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            MOut.G(this).println("Uploading file 1......");
            byte[] data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(1000L);
            data = new byte[]{-3, 124, -77};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            BufferedReader br = new BufferedReader(fr);
            boolean isExtend = false;
            while (br.ready()) {
                String s = br.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                if (s.substring(2, 4).contains("8E") || s.substring(2, 4).contains("8F")) {
                    byte[] data_special = new byte[]{-2, -49, -78, -118};
                    ipmiI2CPMBusCommand.updateVRMdataCommand(data_special);
                } else if (s.substring(2, 4).contains("FC")) continue;
                byte adress = this.get_Adress(s);
                value = this.get_data(s);
                data[0] = adress;
                System.arraycopy(value, 0, data, 1, value.length);
                ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            }
            fr.close();
            data = new byte[]{0, 33};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -48, -41, -17};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -95, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -92, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 33};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -48, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -93, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            slaveAddr = 104;
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(1000L);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(1000L);
            data = new byte[]{-3, 124, -77};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            MOut.G(this).println("Upload file 1 success");
            this.statusCode = 0;
            BufferedReader br2 = new BufferedReader(fr2);
            isExtend = false;
            MOut.G(this).println("Uploading file 2......");
            while (br2.ready()) {
                String s = br2.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                if (s.substring(2, 4).contains("8E") || s.substring(2, 4).contains("8F")) {
                    byte[] data_special = new byte[]{-2, -49, -78, -118};
                    ipmiI2CPMBusCommand.updateVRMdataCommand(data_special);
                } else if (s.substring(2, 4).contains("FC")) continue;
                byte adress = this.get_Adress(s);
                value = this.get_data(s);
                data[0] = adress;
                System.arraycopy(value, 0, data, 1, value.length);
                ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            }
            fr2.close();
            data = new byte[]{0, 33};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -48, -41, -17};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -95, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -92, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 33};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -48, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(500L);
            data = new byte[]{-2, -93, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            MOut.G(this).println("Upload file 2 success");
            MOut.G(this).println("Start Checking data...");
            Thread.sleep(500L);
            slaveAddr = 72;
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            FileReader frc1 = new FileReader(this.parameters[0]);
            if (frc1 == null) {
                MOut.G(this).println("Open file fail.");
                this.statusCode = 147;
                return;
            }
            boolean isFile1upload = false;
            boolean isFile2upload = false;
            BufferedReader brc1 = new BufferedReader(frc1);
            isExtend = false;
            while (brc1.ready()) {
                String s = brc1.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                byte[] readResult = ipmiI2CPMBusCommand.checkVRMdata(adress);
                value = this.get_data(s);
                if (Arrays.equals(value, readResult)) continue;
                MOut.G(this).println("Waning: Data of adress " + Integer.toHexString(adress) + " does not match the file1");
            }
            frc1.close();
            slaveAddr = 104;
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            FileReader frc2 = new FileReader(this.parameters[1]);
            if (frc2 == null) {
                MOut.G(this).println("Open file fail.");
                this.statusCode = 147;
                return;
            }
            BufferedReader brc2 = new BufferedReader(frc2);
            isExtend = false;
            while (brc2.ready()) {
                String s = brc2.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                byte[] readResult = ipmiI2CPMBusCommand.checkVRMdata(adress);
                value = this.get_data(s);
                if (Arrays.equals(value, readResult)) continue;
                MOut.G(this).println("Waning: Data of adress " + Integer.toHexString(adress) + " does not match the file2");
            }
            frc2.close();
            Thread.sleep(500L);
            ipmiHDDOEMCommand.setSensorPollingFlag(true);
            MOut.G(this).println("Please wait for 30s then do the power cycle.");
            MOut.G(this).println("0=update completed with no errors");
        }
    }

    public byte get_Adress(String s) {
        byte adress = (byte)Integer.parseInt(s.substring(2, 4), 16);
        return adress;
    }

    public byte[] get_data(String s) {
        byte[] data = new byte[2];
        String str_value = s.substring(5, 21);
        data[1] = (byte)Integer.parseInt(str_value.substring(0, 8), 2);
        data[0] = (byte)Integer.parseInt(str_value.substring(8, 16), 2);
        return data;
    }

    public static void main(String[] args) throws IOException {
        VRMUpdate3746Command vrm = new VRMUpdate3746Command();
        FileReader fr = new FileReader("D:/Program Files/project/vrmForX10/Dayton_CPU VRM/Dayton_CPU VRM/SG00701.psf");
        BufferedReader br = new BufferedReader(fr);
        boolean isExtend = false;
        while (br.ready()) {
            String s = br.readLine();
            int notePosition = s.indexOf("/");
            if (notePosition == 0) continue;
            if (notePosition > 0) {
                s = s.substring(0, notePosition);
            }
            if (s.substring(1, 2).contains("1")) {
                isExtend = true;
                continue;
            }
            if (s.length() < 21) continue;
            if (s.substring(2, 4).contains("8E")) {
                System.out.println("here1");
            } else if (s.substring(2, 4).contains("8F")) {
                System.out.println("here2");
            } else if (s.substring(2, 4).contains("FC")) continue;
            byte adress = vrm.get_Adress(s);
            byte[] data = vrm.get_data(s);
            System.out.println(adress);
            System.out.println(Integer.toHexString(data[0]) + " " + Integer.toHexString(data[1]));
        }
        fr.close();
    }
}

