package org.apache.log4j.appender;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class TestOneShotStartupRoller extends TestCase {

  private final FileTestHelper helper = new FileTestHelper();

  protected void setUp() throws Exception {
    this.helper.setUp();
  }

  protected void tearDown() throws Exception {
    this.helper.tearDown();
  }

  public void testRollOnStartup() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    appender.setFile(this.helper.filenameForTest("test.log"));
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setRollOnStartup(true);
    this.helper.writeFile("test.log");
    OneShotStartupRoller roller = new OneShotStartupRoller(appender, properties);
    Logger root = Logger.getRootLogger();
    LoggingEvent event = new LoggingEvent(root.getClass().getName(), root,
        Level.INFO, "Hello, world.", null);
    boolean result = roller.roll(event);
    Assert.assertTrue(result);
    // assert repeated calls all return false
    result = roller.roll(event);
    Assert.assertFalse(result);
  }

  public void testNoRollWhenFileIsZeroLengthOnStartup() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    appender.setFile(this.helper.filenameForTest("test.log"));
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setRollOnStartup(true);
    OneShotStartupRoller roller = new OneShotStartupRoller(appender, properties);
    Logger root = Logger.getRootLogger();
    LoggingEvent event = new LoggingEvent(root.getClass().getName(), root,
        Level.INFO, "Hello, world.", null);
    boolean result = roller.roll(event);
    Assert.assertFalse(result);
    // assert repeated calls all return false
    result = roller.roll(event);
    Assert.assertFalse(result);
  }

  public void testNoRollOnStartup() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    appender.setFile(this.helper.filenameForTest("test.log"));
    AppenderRollingProperties properties = new AppenderRollingProperties();
    // properties.setRollOnStartup(true);
    OneShotStartupRoller roller = new OneShotStartupRoller(appender, properties);
    Logger root = Logger.getRootLogger();
    LoggingEvent event = new LoggingEvent(root.getClass().getName(), root,
        Level.INFO, "Hello, world.", null);
    boolean result = roller.roll(event);
    Assert.assertFalse(result);
  }

  public void testNoRollOnStartupExplicitConfig() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    appender.setFile(this.helper.filenameForTest("test.log"));
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setRollOnStartup(false); // explicitly set property
    OneShotStartupRoller roller = new OneShotStartupRoller(appender, properties);
    Logger root = Logger.getRootLogger();
    LoggingEvent event = new LoggingEvent(root.getClass().getName(), root,
        Level.INFO, "Hello, world.", null);
    boolean result = roller.roll(event);
    Assert.assertFalse(result);
  }
}
