@echo off
cls

echo Power Packet Utility Installation is in progress... 
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Begin localizations of subsequent environment changes in this script
setlocal ENABLEDELAYEDEXPANSION

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Checking the required installation files

IF NOT EXIST .\PPUSetup.msi goto FileMissing
IF NOT EXIST .\WinPcap_4_1_3.exe goto FileMissing
IF NOT EXIST .\dynwrapx.dll goto FileMissing

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Read the installated version of WinPcap from registry in a variable

echo Option Explicit >> InstallWinPcap.vbs
echo 'On Error Resume Next >> InstallWinPcap.vbs
echo Dim strSystemOSPath, strValueID, CPIdentifier, Is32bitOS >> InstallWinPcap.vbs
echo Dim strKeyPath, strValueName, strValue, versionString, strValueName1, uninstallPath, msgString, IfInstallWinPcap, IfInstallVC2010, errString, IfFileMissing, Flag >> InstallWinPcap.vbs
echo Dim strComputer, oReg >> InstallWinPcap.vbs
echo Dim wshNetwork, strUser >> InstallWinPcap.vbs
echo Dim objShell,objShell1,objShell2, NetobjShell, spath, path, Netspath, Netpath >> InstallWinPcap.vbs
echo Dim oFSO , NetoFSO >> InstallWinPcap.vbs
echo Dim oMB >> InstallWinPcap.vbs
echo const HKEY_LOCAL_MACHINE = ^&H80000002 >> InstallWinPcap.vbs
echo strComputer = "." >> InstallWinPcap.vbs
echo Set wshNetwork = CreateObject("WScript.Network") >> InstallWinPcap.vbs
echo strUser = wshNetwork.Username >> InstallWinPcap.vbs
echo Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" ^&_  >> InstallWinPcap.vbs
echo strComputer ^& "\root\default:StdRegProv") >> InstallWinPcap.vbs

:: Register dynwrapx.dll
regsvr32.exe /s /i .\dynwrapx.dll

echo Set oMB = CreateObject("DynamicWrapperX") >> InstallWinPcap.vbs
echo oMB.Register "user32.dll", "MessageBoxW", "i=hwwu", "r=l" >> InstallWinPcap.vbs

:: This function is unicode compliant to display a MsgBox in any language
:: It relies in the dynwrapx.dll to be registered
echo Function APIMsgBox(sMsg, sBut, sTitle) >> InstallWinPcap.vbs
echo APIMsgBox = oMB.MessageBoxW(0, sMsg, sTitle, sBut) >> InstallWinPcap.vbs
echo End Function  >> InstallWinPcap.vbs
 
 ::Get the OS version, whether 32bit or 64bit
echo strSystemOSPath = "HARDWARE\DESCRIPTION\System\CentralProcessor\0" >> InstallWinPcap.vbs
echo strValueID = "Identifier" >> InstallWinPcap.vbs
echo oReg.GetStringValue HKEY_LOCAL_MACHINE, strSystemOSPath, strValueID, CPIdentifier >> InstallWinPcap.vbs
echo IF InStr(1, CPIdentifier, "x86") > -1 Then >> InstallWinPcap.vbs
echo 	Is32bitOS = 1 >> InstallWinPcap.vbs
echo Else>> InstallWinPcap.vbs
echo 	Is32bitOS = 0 >> InstallWinPcap.vbs
echo End If >> InstallWinPcap.vbs

::Get the version of WinPcap if installed
echo IF Is32bitOS = "1" Then>> InstallWinPcap.vbs
echo 	strKeyPath = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\WinPcapInst" >> InstallWinPcap.vbs
echo Else>> InstallWinPcap.vbs
echo 	strKeyPath = "SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\WinPcapInst" >> InstallWinPcap.vbs
echo End If >> InstallWinPcap.vbs
echo Dim versionMajorString, versionMinorString >> InstallWinPcap.vbs
echo strValueName = "VersionMajor" >> InstallWinPcap.vbs
echo oReg.GetStringValue HKEY_LOCAL_MACHINE, strKeyPath, strValueName, versionMajorString >> InstallWinPcap.vbs
echo strValueName = "VersionMinor" >> InstallWinPcap.vbs
echo oReg.GetStringValue HKEY_LOCAL_MACHINE, strKeyPath, strValueName, versionMinorString >> InstallWinPcap.vbs


echo Flag = True >> InstallWinPcap.vbs
echo IF versionMajorString ^>= 5 Then >> InstallWinPcap.vbs
echo 	Flag = False >> InstallWinPcap.vbs
echo Else If versionMajorString = 4 and versionMinorString ^>= 1 Then >> InstallWinPcap.vbs
echo 	Flag = False >> InstallWinPcap.vbs
echo Else >> InstallWinPcap.vbs
echo 	Flag = True >> InstallWinPcap.vbs
echo. End If >> InstallWinPcap.vbs
echo.

::if WinPcap is not already installed, ask user if he wants to install WinPcap on system or not
echo IF Flag = True Then >> InstallWinPcap.vbs
echo 	msgString = "WinPcap Software (version 4.1.2 or higher) is either not installed or some previous version is already installed on this workstation. The WinPcap (version 4.1.3) installer is being launched. Please follow the instructions for installing the WinPcap software?  >> InstallWinPcap.vbs
echo 	IfInstallWinPcap = APIMsgBox(msgString, 1, "WinPcap Installation") >> InstallWinPcap.vbs
echo 	IF IfInstallWinPcap = "1" Then >> InstallWinPcap.vbs
		::User pressed "Yes"
echo 		Set objShell = WScript.CreateObject("WScript.Shell") >> InstallWinPcap.vbs
echo 		spath = objShell.CurrentDirectory >> InstallWinPcap.vbs
echo 		path = """" ^& spath ^& ".\WinPcap_4_1_3.exe" ^& "" >> InstallWinPcap.vbs
echo  		Set oFSO = CreateObject("scripting.FileSystemObject") >> InstallWinPcap.vbs
echo   		IF oFSO.FileExists(".\WinPcap_4_1_3.exe") = True Then >> InstallWinPcap.vbs
echo 			objShell.Run path, 0, True >> InstallWinPcap.vbs
echo   		Else >> InstallWinPcap.vbs
echo 			errString = "WinPcap_4_1_3.exe not found. Please copy WinPcap_4_1_3.exe properly before proceeding."  >> InstallWinPcap.vbs
echo 			IfFileMissing = APIMsgBox(errString, 0, "File Missing") >> InstallWinPcap.vbs
echo 			IF IfFileMissing = "1" Then >> InstallWinPcap.vbs
echo				WScript.Quit >> InstallWinPcap.vbs
echo 			End If >> InstallWinPcap.vbs
echo 		End If >> InstallWinPcap.vbs
echo 	End If >> InstallWinPcap.vbs
echo End If >> InstallWinPcap.vbs
echo End If >> InstallWinPcap.vbs
echo.

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Calling the WinPcap installer script always in 32-bit mode
:: Find out if Win_32 or Win_64
IF "%~1"=="" (SET Computer=%ComputerName%) ELSE (SET Computer=%~1)
IF /I NOT "%Computer%"=="%ComputerName%" (
	PING %Computer% -n 2 2>NUL | FIND "TTL=" >NUL || GOTO Syntax
)
FOR /F "tokens=2 delims==" %%A IN ('WMIC /Node:"%Computer%" Path Win32_Processor Get AddressWidth /Format:list') DO SET OSB=%%A

IF %OSB% EQU 32 goto Win_32
IF %OSB% EQU 64 goto Win_64

: Win_32
:: Calling the 32-bit vbscript interpreter for Win-32 OS (default)
%windir%\system32\cscript.exe //NoLogo InstallWinPcap.vbs
goto Continue_Install

: Win_64
:: Calling the 32-bit vbscript interpreter for Win-64 OS
%windir%\SysWOW64\cscript.exe //NoLogo InstallWinPcap.vbs

:Continue_Install
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Delete the intermediate files
del InstallWinPcap.vbs

:: UnRegister dynwrapx.dll
regsvr32.exe /u /s .\dynwrapx.dll

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Calling the PPU installer
.\PPUSetup.msi

echo.
echo.
echo "Task completed. !!!"
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


:InstallationExit
:: End any localizations of environment changes in this script
endlocal

exit /B 0

:FileMissing
echo Some of the installation files are missing. Please copy the files properly before proceeding.
echo Exiting Installer....
pause
exit /B 0
