// Misc. Constants
//      *************************************************
//      *            Miscillanious Constants                                                            *
//      *************************************************

#define PIC1 0x20
#define PIC2 0xA0
#define EOI  0x20

#define TIME_PRO_RESET_DONE  0x028A
#define TIME_PRO_SYSEX       0x001E
#define TIME_PRO_RESET       0x0032

#define NONE   0x00
#define LEFT   0x01
#define RIGHT  0x02
#define GANG   0x03

#define AGND   0x01
#define SIGNAL 0x02

#define EXT_DSP_BIT_DCAL     0x0001
#define EXT_DSP_BIT_MIDI_CON 0x0002

#define BUFFSIZE 0x8000
#define HOSTQ_SIZE 0x40

// Start of SMA control block
#define SRAM_CNTL_START  0x7F00
#define SMA_STRUCT_START 0x7F40

// Data Buffer Sizes

#define DAP_BUFF_SIZE   0x2400
#define DAR_BUFF_SIZE   0x2000

// Queue Sizes

// Queue Sizes
#define DAPQ_STRUCT_SIZE  0x10
#define DARQ_STRUCT_SIZE  0x10
#define DAPQ_BUFF_SIZE  ( 3 * 0x10 )
#define DARQ_BUFF_SIZE  ( 3 * 0x10 )
//	#define MODQ_BUFF_SIZE  0x400
#define MODQ_BUFF_SIZE  0x400
//#define MIDQ_BUFF_SIZE  0x200
#define MIDQ_BUFF_SIZE  0x800
//#define DSPQ_BUFF_SIZE  0x40
#define DSPQ_BUFF_SIZE  0x5A0

// SMA Buffers Offsets
#define DAPQ_DATA_BUFF  0x6C00
#define DARQ_DATA_BUFF  0x6C30
#define MODQ_DATA_BUFF  0x6C60
//#define MIDQ_DATA_BUFF  0x7060
#define MIDQ_DATA_BUFF  0x7060
//#define DSPQ_DATA_BUFF  0x7260
#define DSPQ_DATA_BUFF  0x7860

// SMA Control block offsets
#define DAPQ_OFFSET      SRAM_CNTL_START
#define DARQ_OFFSET      (SRAM_CNTL_START + 0x08)
#define MODQ_OFFSET      (SRAM_CNTL_START + 0x10)
#define MIDQ_OFFSET      (SRAM_CNTL_START + 0x18)
#define DSPQ_OFFSET      (SRAM_CNTL_START + 0x20)

// MIDI port defs
//*** MIDI Output Port Definitions ***
#define WAVEHDR_MOP   (0)       // internal WAVEHDR
#define EXTOUT_MOP    (1)       // external out
#define HWINIT_MOP    (0xFE)    // no port and not NO_MOP
#define NO_MOP        (0xFF)    // no port

#define MAX_MOP       1

//*** MIDI Input Port Definitions ***
#define EXTIN_MIP     (0)       // external in
#define WAVEHDR_MIP   (1)       // internal WAVEHDR
#define HWINIT_MIP    (0xFE)    // no port and not NO_MIP
#define NO_MIP        (0xFF)    // no port

#define MAX_MIP       1


//      *************************************************
//      *                Macro Definitions                                                                      *
//      *************************************************

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;
typedef unsigned short USHORT;
typedef struct DAQueueDataStruct far * LPDAQD;


#define HIWORD(l)    ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF ))
#define LOWORD(l)    ((WORD)(DWORD)(l))
#define HIBYTE(w)    ((BYTE)(((WORD)(w) >> 8 ) & 0xFF ))
#define LOBYTE(w)    ((BYTE)(w))
#define MAKELONG(low,hi) ((long)(((WORD)(low))|(((DWORD)((WORD)(hi)))<<16)))
#define MAKEWORD(low,hi) ((WORD)(((BYTE)(low))|(((WORD)((BYTE)(hi)))<<8)))


#define PCTODSP_OFFSET(w) (USHORT)((w)/2)
#define PCTODSP_BASED(w)  (USHORT)(((w)/2) + DSP_BASE_ADDR)

#define CLI __asm { cli }
#define STI __asm { sti }



//      *************************************************
//      *            Structure/Union Definitions                                          *
//      *************************************************

extern union mem_tag {
   BYTE far *p;
   struct dw_tag {
      WORD l;
      WORD h;
      } dw;
   } pMEM;


struct JobQueueStruct {
		WORD wStart;    // Start Address: DSP word X based
		WORD wSize;     // Queue size in words
		WORD wHead;     // Curr output offset
		WORD wTail;     // Curr input offset
};

struct DAQueueDataStruct {                      // typical digital audio queue data format
		WORD wStart;                            // dsp X:xxxx based buffer address
		WORD wSize;                                     // # of bytes in buffer / avail. buffer size
		WORD wFormat;                           // data format (1 = PCM, 2 = future)
		WORD wSampleSize;               // # of bits per sample
		WORD wChannels;                 // 1 = mono, 2 = stereo, etc.
		WORD wSampleRate;               // samples / sec. (ie. 44kHz = 44100)
		WORD wIntMsg;                           // TXH/TXM data @ int/completion time
		WORD wFlags;        // User Data
};

struct SMA0_CommonData {
	WORD wCurrPlayBytes;		//	0x00	// # of BYTEs played in current play job
	WORD wCurrRecordBytes;    //	0x02  	// # of BYTEs recorded in current record job
	WORD wCurrPlayVolLeft;    //	0x04	// current wave output volume - left
	WORD wCurrPlayVolRight;   //	0x06// current wave output volume - right

	WORD wCurrInVolLeft;		//	0x08	//	; current input mixer volume - left
	WORD wCurrInVolRight;		//	0x0A	//	; current input mixer volume - right
	WORD wCurrMHdrVolLeft;	//	0x0C	//	; current MIDI output volume - left
	WORD wCurrMHdrVolRight;	//	0x0E	//	; current MIDI output volume - right

	DWORD dwCurrPlayPitch;		//			//	; current play pitch: MSW = int, LSW = frac
	DWORD dwCurrPlayRate;		//			//	; current play rate: MSW = int, LSW = frac

	WORD wCurrMIDIIOPatch;	//			//	; current MIDI I/O patch setup

	WORD wCurrPlayFormat;		//			//	; current playback data format (1=PCM)
	WORD wCurrPlaySampleSize;	//			//	;    "       "     sample size in bits
	WORD wCurrPlayChannels;	//			//	;    "       "     # of channels (1=mono)
	WORD wCurrPlaySampleRate;	//			//	;    "       "     data output rate

	WORD wCurrRecordFormat;	//			//	; current recorder data format
	WORD wCurrRecordSampleSize;			//	    "       "     sample size in bits
	WORD wCurrRecordChannels;	//			//	;    "       "     # of channels (2=stereo)
	WORD wCurrRecordSampleRate;			//	;    "       "     data output rate

	WORD wCurrDSPStatusFlags;		// current DSP status flags:
									//	;  0	play underflow
									//	;  1	record overflow
									//	;  2	play paused
									//	;  3	in mix enabled
									//	;  4	play reverse enabled
									//	;  5    - spare -
									//	;  6    record active
									//	;  7    MIDI in active
									//	;  8	- spare -
									//	;  9	- spare -
									//	; 10	play back rate != 1.00
									//	; 11	play pitch != 1.00
									//	; 12	play time comp != 1.00
									//	; 13	play EQ bands != 1.00
									//	; 14	- spare -
									//	; 15	- spare -

	WORD wCurrHostStatusFlags;	// current Host status flags:
									//	;  0	ACAL w/ AGND ref
									//	;  1	DSP has run before
									//	;  2	Record monitor enabled

	WORD wCurrInputTagBits;     // current A/D clipping tag bits
	WORD wCurrLeftPeak;         // current A/D left  peak value
	WORD wCurrRightPeak;        // current A/D right peak value

	//	WORD wExtDSPbits;           // external DSP harware bits:
	//	;-12-20-96 switch left and right
	BYTE bMicPotPosLeft;			//	; mic    pot right setting (0->FF)
	BYTE bMicPotPosRight;			//	; mic    pot left  setting (0->FF)

	BYTE bMicPotMaxLeft;			//	; mic    pot right setting (0->FF)
	BYTE bMicPotMaxRight;			//	; mic    pot left  setting (0->FF)

	BYTE bInPotPosLeft;         // input  pot right setting (0->FF)
	BYTE bInPotPosRight;        // input  pot left  setting (0->FF)
	
	BYTE bAuxPotPosLeft;        // aux/CD pot right setting (0->FF)
	BYTE bAuxPotPosRight;       // aux/CD pot left  setting (0->FF)
	
	BYTE bInPotMaxLeft;		//	; input  pot right setting (0->FF)
	BYTE bInPotMaxRight;		//	; input  pot left  setting (0->FF)
	BYTE bAuxPotMaxLeft;		//	; aux/CD pot right setting (0->FF)
	BYTE bAuxPotMaxRight;		//	; aux/CD pot left  setting (0->FF)
	BYTE bInPotMaxMethod;		//	;*nu* input  pot max method
	BYTE bAuxPotMaxMethod;		//	;*nu* aux/CD pot max method
								//	;*nu* 0=off, 1=var, 2=2Vrms, 3=0.5Vrms, 4=fut.
	WORD wCurrMastVolLeft;	//	; master left  volume scalar
	WORD wCurrMastVolRight;	//	; master right volume scalar

	WORD wCalFreqAtoD;

	WORD wCurrAuxVolLeft;		//	; aux left  volume
	WORD wCurrAuxVolRight;	//	; aux right volume

	WORD wCurrPlay1VolLeft;
	WORD wCurrPlay1VolRight;
	WORD wCurrPlay2VolLeft;
	WORD wCurrPlay2VolRight;
	WORD wCurrPlay3VolLeft;
	WORD wCurrPlay3VolRight;
	WORD wCurrPlay4VolLeft;
	WORD wCurrPlay4VolRight;
	WORD wCurrPlay1PeakLeft;
	WORD wCurrPlay1PeakRight;
	WORD wCurrPlay2PeakLeft;
	WORD wCurrPlay2PeakRight;
	WORD wCurrPlay3PeakLeft;
	WORD wCurrPlay3PeakRight;
	WORD wCurrPlay4PeakLeft;
	WORD wCurrPlay4PeakRight;
	WORD wCurrPlayPeakLeft;
	WORD wCurrPlayPeakRight;

	WORD wCurrDATSR;
	WORD wCurrDATRXCHNL;
	WORD wCurrDATTXCHNL;
	WORD wCurrDATRXRate;

    DWORD   dwDSPPlayCount;


};


//      *************************************************
//      *            Functional Prototypes                                                *
//      *************************************************

extern void InitializeSMA( void );
extern BYTE ResetMsndIRQ( void );
extern BYTE SetupMsndIRQ( void );
extern BYTE SetIntMap( BYTE bIrq );
extern BYTE UploadDSPCode( void );
extern BYTE uploadbin( char *szBinFileName );
extern BYTE uploadreb( char *szRebFileName );
extern BYTE SendHostWord( BYTE bHi, BYTE bMid , BYTE bLow );
extern BYTE SendDSPCommand( BYTE bCommand );
extern BYTE WaitTXDEmpty( void );
extern BYTE WaitHostClear( void );
extern BYTE ResetDSP( void );
extern void SetMidiInPort( BYTE bNewMIP );
extern void SetMidiOutPort( BYTE bNewMop );
extern WORD MIDPortRead( void );
extern void MODPortWrite( WORD wMidiData );
extern BYTE SetAuxVolume( BYTE bVolume , BYTE bType );
extern BYTE SetInVolume( BYTE bVolume , BYTE bType );
extern WORD GetExtDSPbits( void );
extern void GetDelayTime( WORD wDelayTime );
extern void ResetProteus( void );
extern BYTE CalibrateAD( WORD wSampleRate , BYTE bGndType );


//      *************************************************
//      *            Global Variable Definitions                                          *
//      *************************************************

extern void( __interrupt __far *nDSPSaveVect )();
extern BYTE bIrq, bMem;
extern WORD wBASEIO;
extern WORD wCFGIO;
extern int nIRQValue;

extern WORD wMPUIO;
extern WORD nMPUIRQ;
extern WORD wCDIO0;
extern WORD wCDIO1;
extern WORD nCDIRQ;
extern WORD wJOYIO;


extern WORD *pwHostQueue , *pwHostHead , *pwHostTail;
extern struct JobQueueStruct far *DAPQ , *DARQ , *MODQ , *MIDQ , *DSPQ;
extern struct SMA0_CommonData far *SMA;
extern struct DAQueueDataStruct far *CurDAQD;
extern struct DAQueueDataStruct far *CurDARQD;
extern WORD far *pwDSPQData , *pwMIDQData , *pwMODQData;
extern BYTE bCurrBank;
extern BYTE far *pbDSPinit;
extern BYTE far *pbDSPperm;


// external variables defined in dspcode.obj

extern BYTE     bDspInitStart;
extern WORD     wDspInitSize;
extern BYTE     bDspPermStart;
extern WORD     wDspPermSize;
extern WORD     wDspPermWords;

