/************************************************************************
 *     MultiSound Record Example Program
 *
 *               Records a PCM sound file based on the parameters defined at
 *               compile time:
 *
 *               SAMPLE_RATE                    44100 / 22050 / 11025
 *               BITS             16 / 8
 *               CHANNELS         2 / 1
 *
 *               The command line parameter is the full path and name of the
 *               file to record to.
 *
 *
 *     Copyright 1992  Turtle Beach Systems Inc., All rights reserved.
 *
 *
 * **********************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <conio.h>
#include <DOS.H>
#include "msnd_dsp.h"
#include "pcontrol.h"

#define INT1 {_asm int 1}
#define INT3 {_asm int 3}

#define SAMPLE_RATE ( 44100 )
#define BITS        ( 16 )
#define CHANNELS    ( 2 )
#define PCM         ( 1 )

FILE *f_point;

BYTE bTerminator = 0;
BYTE bLastBank = 0xFF;
BYTE *pbHostBuffer;
WORD wTemp;
BYTE bTemp;

BYTE far *pbCurRecordBuff;

void EvalDSPMessage( WORD wDSPMessage );
void SetupRecordStruct( BYTE bBank );

main(argc, argv)
int argc;
char *argv[];
{
    bMem            = HPMEM_D000;
    //bIrq            = HPIRQ_10;
    //nIRQValue       = 10;
    bIrq            = HPIRQ_9;
    nIRQValue       = 9;
    pMEM.dw.h       = 0xD000;
    pMEM.dw.l       = 0x0000;
    wBASEIO         = 0x290;          // DSP base address to program.

                                        // non plug and play jumpers as follows:
    wCFGIO          =0x250;           //     -------------------
                                      //     | /-------------\ |    address x250
                                      //     | |   o     o   | |
                                      //     | \-------------/ |
                                      //     |                 |
                                      //     |     o     o     |
                                      //     |                 |
                                      //     -------------------

    
    pbCurRecordBuff = pMEM.p;


    if( ( pbHostBuffer=calloc(sizeof(BYTE), DAP_BUFF_SIZE ) ) == NULL ) exit(0);
    if( ( pwHostQueue = calloc( sizeof(WORD) , HOSTQ_SIZE ) ) == NULL ) exit(0);
    pwHostHead = pwHostQueue;
    pwHostTail = pwHostQueue;

    //outp( ( wBASEIO + HP_WAIT ) , HPWAITSTATE_0 );
    //outp( ( wBASEIO + HP_BITM ) , HPBITMODE_16 );



    InitializeSMA();


    if (!UploadDspCode())
    {
        printf("Failed to upload and initialize DSP\n");
        exit(0);
    }



    SetupMsndIRQ();

    SetInVolume( 0xDF, GANG );
    SetMicVolume( 0xDF , GANG );

    for( bTemp = 0 ; bTemp < 3 ; bTemp++ ) {
        SetupRecordStruct( bTemp );
        CurDARQD++;
    }

    if( ( f_point = fopen( argv[1], "wb" ) ) == NULL ) {
        printf("Unable to open file\n");
        ResetMsndIRQ();
        exit(0);
    }

    // drain the queue if there is anything in there to begin with.
    while ( pwHostTail != pwHostHead ) {
        if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
            pwHostHead = pwHostQueue;
            printf("Wrapping Host Queue\n");
        }
        // ignore these,
        // before we start recording we get various overflow
        // and underflow messages from the DSP
        //EvalDSPMessage( *pwHostHead );
    }
    printf( "Hit the spacebar to begin recording\n" );

    while ( !kbhit() ) {}
    switch ( getch() )
    {
        case 0x71:
        case 0x51:
            ResetMsndIRQ();
            fclose( f_point );
            exit( 0 );
            break;

        default:
            break;
    }

    DARQ->wTail = DARQ_STRUCT_SIZE;       // *** This Changed ***
                                        // 2 buffers , half struct size each
                                        // in DSP sizes
    SendDSPCommand( HDEX_RECORD_START );

    while( !kbhit() && !bTerminator ) {
        if( pwHostTail != pwHostHead ) {
            if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
                pwHostHead = pwHostQueue;
                printf("Wrapping Host Queue\n");
            }
            EvalDSPMessage( *pwHostHead );
        }
    }

    SendDSPCommand(HDEX_RECORD_STOP);


    // drain the queue if there is anything in there to begin with.
    while ( pwHostTail != pwHostHead ) {
        if( ++pwHostHead >= (pwHostQueue + HOSTQ_SIZE ) ) {
            pwHostHead = pwHostQueue;
            printf("Wrapping Host Queue\n");
        }
        EvalDSPMessage( *pwHostHead );
    }

    ResetMsndIRQ();

    fclose( f_point );

    return(0);

}


void SetupRecordStruct( BYTE bBank )
{
    CurDARQD->wStart      = PCTODSP_BASED( (DWORD)( DAR_BUFF_SIZE * bBank ) ) + 0x4000;
    CurDARQD->wSize       = DAR_BUFF_SIZE;
    CurDARQD->wFormat     = PCM;
    CurDARQD->wSampleSize = BITS;
    CurDARQD->wChannels   = CHANNELS;
    CurDARQD->wSampleRate = SAMPLE_RATE;
    CurDARQD->wIntMsg     = HIMT_RECORD_DONE * 0x100 + bBank;
    CurDARQD->wFlags      = bBank + 1;
}


void EvalDSPMessage( WORD wMessage )
{
    switch ( HIBYTE( wMessage ) )
    {
        case HIMT_PLAY_DONE:
            switch ( LOBYTE( wMessage ) )
            {
                case 0x01:
                    break;

                case 0x02:
                    break;

                case 0x00:
                    break;

                default:
                    break;
            }
            break;

        case HIMT_DSP:
            switch ( LOBYTE( wMessage ) )
            {
                case HIDSP_PLAY_UNDER:
                    printf("HIDSP_PLAY_UNDER\n");
                    break;

                case HIDSP_INT_PLAY_UNDER:
                    printf( "HIDSP_INT_PLAY_UNDER\n" );
                    break;

                case HIDSP_SSI_TX_UNDER:
                    printf( "HIDSP_SSI_TX_UNDER\n" );
                    break;
                case HIDSP_RECQ_OVERFLOW:
                    printf( "HIDSP_RECQ_OVERFLOW\n" );
                    break;
                case HIDSP_INT_REC_OVERFLOW:
                    printf( "HIDSP_INT_REC_OVERFLOW\n" );
                    break;
                case HIDSP_SSI_RX_OVERFLOW:
                    printf( "HIDSP_SSI_RX_OVERFLOW\n" );
                    break;
                case HIDSP_MIDI_FRAME_ERR:
                    printf( "HIDSP_MIDI_FRAME_ERR\n" );
                    break;
                case HIDSP_MIDI_PARITY_ERR:
                    printf( "HIDSP_MIDI_PARITY_ERR\n" );
                    break;
                case HIDSP_INPUT_CLIPPING:
                    printf( "HIDSP_INPUT_CLIPPING\n" );
                    break;
                case HIDSP_MIX_CLIPPING:
                    printf( "HIDSP_MIX_CLIPPING\n" );
                    break;
                case HIDSP_DAT_IN_OFF:
                    printf( "HIDSP_DAT_IN_OFF\n" );
                    break;
                case HIDSP_MIDI_IN_OVER:
                    printf( "HIDSP_MIDI_IN_OVER\n" );
                    break;
                case HIDSP_MIDI_OVERRUN_ERR:
                    printf( "HIDSP_MIDI_OVERRUN_ERR\n" );
                    break;
                default:
                    printf("ERROR: UNKNOWN_DSP_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
                    break;
            }
            break;

        case HIMT_RECORD_DONE:
        {
            struct DAQueueDataStruct far *pDARQData;
            DWORD dwAddr;
            WORD wDataSize;
            
            bLastBank = LOBYTE( wMessage );

            dwAddr = (((bLastBank * (DARQ_STRUCT_SIZE / 2) ) + DARQ->wStart) - DSP_BASE_ADDR) * 2;
            

            pDARQData = (struct DAQueueDataStruct far *)(dwAddr + pMEM.p);

            //printf("pDARQData = %lx\n", pDARQData);

            wDataSize = pDARQData->wSize;
            if (pDARQData->wSize)
            {
                // calculate the address relative to our address space in bank 1
                dwAddr = (pDARQData->wStart - (DSP_BASE_ADDR + DSP_BANK_BASE)) * 2;
                pbCurRecordBuff = ( BYTE far *)( dwAddr + pMEM.p);

                //printf("pbCurRecordBuff = %lx, %x\n", pbCurRecordBuff, wDataSize);

                // record is in bank 1.
                CLI;
                outp( wBASEIO + HP_BLKS , HPBLKSEL_1 );
                bCurrBank = 1;
                STI;


                // Do mem copy into host memory to free up DSP mem as fast as possible
                // this double buffering is a new addition
                _fmemcpy( pbHostBuffer , pbCurRecordBuff , DAR_BUFF_SIZE );

                CLI;
                outp( wBASEIO + HP_BLKS , HPBLKSEL_0 );
                bCurrBank = 0;
                STI;

            }


            pDARQData->wSize = DAR_BUFF_SIZE;   // prep buffer for next time.
            wTemp = DARQ->wTail +  (DARQ_STRUCT_SIZE / 2 );
            if( wTemp > DARQ->wSize ) {
                wTemp = 0;
            }
            while( wTemp == DARQ->wHead );   // Wait if we are going to wrap the queue
            DARQ->wTail = wTemp;

            // Once the DSP memory is free we can write to disk
            // this is a new addition
            if (wDataSize)
                fwrite( pbHostBuffer , sizeof( BYTE ) , wDataSize , f_point );




            break;
        }

        case HIMT_MIDI_IN_UCHAR:
            printf( "HIMT_MIDI_IN_UCHAR\n" );
            break;
        default:
                printf("ERROR: UNKNOWN_MESSAGE %X : %X\n" , HIBYTE( wMessage ) , LOBYTE( wMessage ) );
                break;

    }
}


