
/*
  This file contains the defines and function prototypes for the ENSONIQ
  Soundscape Digital Audio Driver API. See the READ.ME file for a driver
  description.
*/  


#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>


/* some necessary typedefs ... */
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;


/* The driver version numbers */
#define VER_MAJOR       3
#define VER_MINOR       50

/*
   The following define is the digital audio buffer size, in bytes. This
   buffer will be logically divided in half by the driver; the application
   will fill the audio buffer in BUFFERSIZE/2 byte chunks. Generally,
   BUFFERSIZE/2 should be a multiple of 4 and should represent approximately
   1/16th sec of audio for the given format for continuous audio streaming,
   or smaller for interactive, multi-channel mixing applications. If multiple
   formats are required, this size can be adjusted dynamically. The buffersize
   below is set for 22050 Hz, 8-bit, stereo data.
*/
#define BUFFERSIZE      5512U


/* Some globals that the app may need to know about ... */
extern WORD      BasePort;              /* Soundscape Base / MPU-401 port */
extern short     MidiIrq;               /* the MPU-401 IRQ */
extern WORD      WavePort;              /* the CoDec base port */
extern short     WaveIrq;               /* the CoDec Wave IRQ */
extern short     DmaChan;               /* the CoDec Wave DMA channel */


/*
  Following are the prototypes for all of the driver functions that are
  directly invoked by the application code ... the API functions
*/


/*
  short DetectSoundscape(void);

  This function is used to detect the presence of a Soundscape card in a
  system. It will read the hardware config info from the SNDSCAPE.INI file,
  the path to which is indicated by the SNDSCAPE environment variable. This
  config info will be stored in global variable space for the other driver
  functions to reference. Once the config settings have been determined, a
  hardware test will be performed to see if the Soundscape card is actually
  present. If this function is not explicitly called by the application, it
  it will be called by the OpenSoundscape function.

  INPUTS:
	None

  RETURNS:
	0   - if Soundscape detection was successful
	-1  - if
		The SNDSCAPE environment variable was not found
		The SNDSCAPE.INI file cannot be opened
		The SNDSCAPE.INI file is missing information or is corrupted
		The Soundscape hardware is not detected
*/

  short DetectSoundscape(void);


/*
  short OpenSoundscape(void);

  This function opens the Soundscape driver. It will setup the Soundscape
  hardware for Native PCM mode (the default mode is Sound Blaster emulation).
  It will first call the DetectSoundscape function it it determines that it
  has not already been called.

  INPUTS:
	None.

  RETURNS:
	0   - if successful
	-1  - if the DetectSoundscape function needed to be called and
	      returned unnsuccessful.
*/

short OpenSoundscape(void);


/*
  void StartCoDec(WORD srate, short stereo, short size16bit, short direction);

  This function will start the CoDec auto-restart DMA process.

  INPUTS:
	srate      - the audio sample rate in Hertz
	stereo     - 0 for mono data, 1 for L/R interleaved stereo data
	size16bit  - 0 for 8-bit unsigned data, 1 for 16-bit signed data
	direction  - 0 for playback, 1 for record

  RETURNS:
	0          - if the CoDec was started successfully
	-1         - if the sample rate is unacceptable
*/

short StartCoDec(WORD srate, short stereo, short size16bit, short direction);


/*
  char *GetBuffer(void);

  This function is used by the application, normally in a polling fashion,
  to get a pointer to the next buffer half to be filled.

  INPUTS:
	None

  RETURNS:
	0      - if the CoDec is not ready for audio data
	non-0  - a pointer to a BUFFERSIZE/2 byte buffer will be returned if
		 the CoDec is ready for data
*/

char *GetBuffer(void);


/*
  void PauseCoDec(void);

  This function will pause the CoDec auto-restart DMA process.

  INPUTS:
	None

  RETURNS:
	Nothing
*/

void PauseCoDec();


/*
  void ResumeCoDec(short direction);

  This function will pause the CoDec auto-restart DMA process.

  INPUTS:
	direction  - 0 for playback, 1 for record

  RETURNS:
	Nothing
*/

void ResumeCoDec(short direction);


/*
  void StopCoDec(void);

  This function will stop the CoDec auto-restart DMA process.

  INPUTS:
	None

  RETURNS:
	Nothing
*/

void StopCoDec(void);


/*
  void CloseSoundscape(void);

  This function will make sure the CoDec is stopped, return the Soundscape
  hardware to it's default Sound Blaster emulation mode, de-install the PCM
  interrupt, resore the PIC mask, and do other cleanup.

  INPUTS:
	None

  RETURNS:
	None
*/

void CloseSoundscape(void);


/*
  void SetDacVol(short lvol, short rvol);

  This function sets the left and right DAC output level in the CoDec.

  INPUTS:
	lvol  - left volume, 0-127
	rvol  - right volume, 0-127

  RETURNS:
	Nothing

*/

void SetDacVol(short lvol, short rvol);


/*
  void SetCdRomVol(short lvol, short rvol);

  This function sets the left and right CD-ROM output level in the CoDec.

  INPUTS:
	lvol  - left volume, 0-127
	rvol  - right volume, 0-127

  RETURNS:
	Nothing

*/

void SetCdRomVol(short lvol, short rvol);


/*
  void SetAdcVol(short lvol, short rvol);

  This function sets the left and right ADC input level in the CoDec.

  INPUTS:
	lvol  - left volume, 0-127
	rvol  - right volume, 0-127

  RETURNS:
	Nothing

*/

void SetAdcVol(short lvol, short rvol);

