
#include <stdio.h>
#include <conio.h>
#include "driver.h"


char TmpBuff[64];

main(int argc, char *argv[]) {
	int      size16bit, stereo;
	char    *wavfile;
	BYTE     zero;
	WORD     i, cc;
	DWORD    srate;
	FILE    *fp = 0;
	char    *bp = 0;

	printf("\nSoundscape Digital Audio Driver, Version %d.%02d\n",
		VER_MAJOR, VER_MINOR);

	printf("\nDetecting Soundscape ...\n");
	if( DetectSoundscape() ) {
		printf("\t\007Soundscape Board Not Found\n\n");
		return -1;
	}

	printf("\n\tSoundscape Hardware Settings:\n");
	printf("\t\tBase/MIDI Port : %03x\n", BasePort);
	printf("\t\tMIDI IRQ :       %d\n", MidiIrq);
	printf("\t\tWave Port :      %03x\n", WavePort);
	printf("\t\tWave IRQ :       %d\n", WaveIrq);
	printf("\t\tDMA Channel :    %d\n\n", DmaChan);

	printf("Opening Soundscape Driver ...\n");
	if( OpenSoundscape() ) {
		printf("\t\007Soundscape Driver Open Failed\n\n");
		return -1;
	}

	if(argc < 2)
		wavfile = "tst8s22.wav";
	else
		wavfile = argv[1];

	printf("Opening \"%s\" ...\n", wavfile);
	if( !(fp = fopen(wavfile, "rb")) ) {
		printf("\t\007Input File \"%s\" Not Found\n\n", wavfile);
		goto exit;
	}

	/* a VERY crude .WAV header interpretation - assumes alot */
	printf("Reading .WAV File Header ...\n");
	fread(TmpBuff, 44, 1, fp);

	/* make sure it's linear PCM */
	if( *((WORD *) TmpBuff + 10) != 1 ) {
		printf("\t\007.WAV Format Not Supported\n\n");
		goto exit;
	}

	/* set the format variables */
	size16bit = *((WORD *) TmpBuff + 17) >> 4;
	stereo = *((WORD *) TmpBuff + 11) >> 1;
	srate = *((DWORD *) TmpBuff + 6);

	printf("\tAudio Format: %s, %s, %lu Hz\n\n",
		size16bit? "16-bit": "8-bit", stereo? "stereo": "mono", srate);

	/* set the zero value for buffer filling */
	if( size16bit )
		zero = 0;
	else
		zero = 0x80;

	printf("Starting Digital Audio DMA ...\n");
	if( StartCoDec((WORD) srate, size16bit, stereo, 0) ) {
		printf("\t\007Sample Rate Not Supported\n\n");
		goto exit;
	}

	for(;;) {
		printf("\tPress any key to Play the .WAV file, 'x' to exit ...\n");
		i = (WORD) getch();
		if( i == 'x' || i == 'X' )
			break;

		/* rewind the file */
		fseek(fp, 44, SEEK_SET);

		/* chug on the file until it's empty */
		while( !feof(fp) ) {
			/* get a buffer-half to fill */
			while( !(bp = GetBuffer()) )
				;

			/* read in a file chunk */
			cc = fread(bp, 1, BUFFERSIZE >> 1, fp);
		}

		/* zero whatever is left of the current buffer */
		for( i = cc; i < BUFFERSIZE/2; ++i )
			*(bp + i) = zero;

		/* now, zero the two buffers as they become available ... */
		for( cc = 0; cc < 2; ++cc ) {
			/* wait for the next buffer ... */
			while( !(bp = GetBuffer()) )
				;

			/* zero it */
			for( i = 0; i < BUFFERSIZE/2; ++i )
				*(bp + i) = zero;
		}
	}
	
	printf("\nStopping Digital Audio DMA ...\n");
	StopCoDec();
exit:
	printf("Closing Soundscape Driver ...\n");
	CloseSoundscape();

	if( fp )
		fclose(fp);
	
	return 0;
}

