/* MPU-401 Register Defines */
#define MPU_BASE	0x330
#define MPU_DATA	(MPU_BASE + 0)
#define MPU_STAT	(MPU_BASE + 1)
#define MPU_CMD		(MPU_BASE + 1)

/* MPU-401 Status Register Bit Defines */
#define MPU_TXRDY	6
#define MPU_RXRDY	7

/* MPU-401 Command Defines */
#define MPU_RESET	0xff
#define MPU_UART	0x3f
#define MPU_ACK		0xfe

/* MPU-401 Receive Buffer Size (bytes) */
#define	MPU_BUFSIZ	256

/* Interrupt Controller Values */
#define	VECT1_BASE	0x08		/* Base Int Vect1 for IRQs */
#define	VECT2_BASE	0x70		/* Base Int Vect2 for IRQs */
#define ICTL1_CMD	0x20		/* 8259 Controller 1 Cmd Reg */
#define ICTL1_MSK	0x21		/* 8259 Controller 1 Mask Reg */
#define ICTL2_CMD	0xa0		/* 8259 Controller 2 Cmd Reg */
#define ICTL2_MSK	0xa1		/* 8259 Controller 2 Mask Reg */
#define ICTL_EOI	0x20		/* 8259 End Of Int Command */

/* Errors */
#define MPU_OK			0	/* Normal return value */
#define MPU_ERR_TXTMOUT		1	/* Timeout waiting to transmit */
#define MPU_ERR_RXTMOUT		2	/* Timeout waiting to receive */
#define MPU_ERR_BADACK		3	/* Bad Acknowledge return */
#define MPU_ERR_BADIRQ		4	/* Bad IRQ selected */


/* Function Prototypes */
	/* Open the MPU-401, UART Mode at specified IRQ */
extern int		     mpu_open(int irq);

	/* Write a byte, timeout after TMOUT clocks, 0 TMOUT waits forever */
extern int		     mpu_send(unsigned char data, long tmout);

	/* Read a byte, timeout after TMOUT clocks, 0 TMOUT waits forever */
extern int		     mpu_recv(unsigned char *datap, long tmout);

	/* Flush the recv buffer */
extern void		     mpu_flush(void);

	/* Close the MPU-401 */
extern void		     mpu_close(void);

/**************************************************************************
* The TMOUT entries in the mpu_recv and mpu_send functions are specified *
* as a number of clocks ticks where the actual number of clock ticks per  *
* second is specified by CLOCKS_PER_SEC in <time.h>.                      *
***************************************************************************/


/* External variable declarations */
void _interrupt _far	mpu_isr(void);		/* Receive ISR */
extern unsigned char	mpu_buf[];		/* Receive Buffer */
extern int		mpu_overflow;		/* Receive Overflow Status */
extern int volatile	mpu_rindx;		/* Receive Buffer Read Index */
extern int volatile	mpu_windx;		/* Receive Buffer Write Index */
extern int		mpu_irq;		/* The IRQ being used */
