//------------------------------------------------------------------------------
// File: Bdasampl.h
//
// Desc: Sample code header file for BDA graph building.
//
// Author: Dave Smith
//
// Copyright (c) 2003, Conexant Systems, Inc. All rights reserved.
//------------------------------------------------------------------------------

#ifndef BDASAMPL_H_INCLUDED_
#define BDASAMPL_H_INCLUDED_

#include <streams.h>
#include <mmreg.h>
#include <msacm.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <atlbase.h>
#include <ks.h>
#include <ksmedia.h>
#include <bdatypes.h>
#include <bdamedia.h>
#include <bdaiface.h>
#include <bdatif.h>
#include <tuner.h>
#include <uuids.h>
#include <commctrl.h>
#include <tchar.h>
#include <cassert>

#include "resource.h"


//-----------------------------------------------------------------------------
LRESULT CALLBACK    WndProc(HWND, UINT, WPARAM, LPARAM);

BOOL CALLBACK       DlgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK       AboutDlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK       SelectChannelDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK       SettingDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK       DemuxPIDDlgProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

static VOID         SetCarrierFrequency(HWND hDlg);

static VOID         SetVideoPID(HWND hDlg);
static VOID         SetAudioPID(HWND hDlg);

static VOID         RemoveCommas(TCHAR* pCommaBuff, TCHAR* pCommaFreeBuff);

VOID                ErrorMessageBox(LPTSTR sz,...);

#endif // BDASAMPL_H_INCLUDED_

