
#define FILE_ANY_ACCESS     0
#define METHOD_BUFFERED     0

#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

//
// Device IOControl call
//

#define THBDA_IO_INDEX    0xAA00


//*******************************************************************************************************
//Functionality : Check BDA driver if support IOCTL interface
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CHECK_INTERFACE             CTL_CODE(THBDA_IO_INDEX, 121, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Get driver info
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : struct DriverInfo
//OutBufferSize : sizeof(DriverInfo) bytes
//*******************************************************************************************************
#define THBDA_IOCTL_GET_DRIVER_INFO             CTL_CODE(THBDA_IO_INDEX, 125, METHOD_BUFFERED, FILE_ANY_ACCESS) 

//*******************************************************************************************************
//Functionality : Set Twinhan BDA driver configuration
//InBuffer      : struct THBDAREGPARAMS
//InBufferSize  : sizeof(THBDAREGPARAMS) bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//*******************************************************************************************************
#define THBDA_IOCTL_SET_REG_PARAMS              CTL_CODE(THBDA_IO_INDEX, 122, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Get CI state
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : struct THCIState
//OutBufferSize : sizeof(THCIState) bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_GET_STATE                CTL_CODE(THBDA_IO_INDEX, 200, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Get APP info.
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : struct THAppInfo
//OutBufferSize : sizeof(THAppInfo) bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_GET_APP_INFO             CTL_CODE(THBDA_IO_INDEX, 201, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Init MMI
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_INIT_MMI                 CTL_CODE(THBDA_IO_INDEX, 202, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Get MMI
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : struct THMMIInfo
//OutBufferSize : sizeof(THMMIInfo) bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_GET_MMI                  CTL_CODE(THBDA_IO_INDEX, 203, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Answer
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : struct THMMIInfo
//OutBufferSize : sizeof(THMMIInfo) bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_ANSWER                   CTL_CODE(THBDA_IO_INDEX, 204, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Close MMI
//InBuffer      : NULL
//InBufferSize  : 0 bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_CLOSE_MMI                CTL_CODE(THBDA_IO_INDEX, 205, METHOD_BUFFERED, FILE_ANY_ACCESS)

//*******************************************************************************************************
//Functionality : Send PMT
//InBuffer      : PMT data buffer
//InBufferSize  : PMT data buffer size bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//Comment       : CA_PMT data format
                    //1: ca pmt list management;(8 bit);
                    //2: program number (16 bit);
                    //3: reserved (2 bit);
                    //4: version number (5 bit);
                    //5: current next indicator (I bit);
                    //6: reserved (4 bit);
                    //7: program information length (12 bit);
                    //8: if (7!=0)
                    //	    ca pmt command id (program level); (8 bit);
                    //	    ca descriptor at program level; (n * 8bit);
                    //9:  stream type (8 bit);
                    //10: reserved (3 bit);
                    //11: elementary stream PID (bit 13);
                    //12: reserved (4 bit);
                    //13: ES information length (12 bit);
                    //14: if (ES information length ! =0)
                    //       ca pmt command id ( elementary stream level) (8 bit);
                    //	     ca descriptor at elementary stream level; ( n * 8bit)
                    //* more detail, please refer to EN 50221 (8,4,3,4 CA_PMT); 
//*******************************************************************************************************
#define THBDA_IOCTL_CI_SEND_PMT                 CTL_CODE(THBDA_IO_INDEX, 206, METHOD_BUFFERED, FILE_ANY_ACCESS)



//*******************************************************************************************************
//Functionality : Send PMT
//InBuffer      : PMT data buffer
//InBufferSize  : PMT data buffer size bytes
//OutBuffer     : NULL
//OutBufferSize : 0 bytes
//*******************************************************************************************************
#define THBDA_IOCTL_CI_PARSER_PMT               CTL_CODE(THBDA_IO_INDEX, 207, METHOD_BUFFERED, FILE_ANY_ACCESS)


#define ME0						1
#define ME1						2
#define MMI0					3
#define MMI1					4
#define MMI0_ClOSE				5
#define MMI1_CLOSE				6
#define NON_CI_INFO				0


typedef enum _CAM_TYPE_ENUM
{
    CAM_DEFAULT = 1, //Viaccess
    TH_CAM_ASTON = 2,
    TH_CAM_CONAX = 3,
    TH_CAM_CRYPTOWORKS = 4    
}  CAM_TYPE_ENUM;

typedef struct {
	GUID    CmdGUID;            // Private Command GUID
    DWORD   dwIoControlCode;    // operation
    LPVOID  lpInBuffer;         // input data buffer
    DWORD   nInBufferSize;      // size of input data buffer
    LPVOID  lpOutBuffer;        // output data buffer
    DWORD   nOutBufferSize;     // size of output data buffer
    LPDWORD lpBytesReturned;    // byte count
} THBDACMD, *PTHBDACMD;

typedef struct {
    ULONG ulMCEFreqTranslate;     // MCE frequency table translate
    ULONG ulFixedBW;              // The fixed bandwidth in registry
    ULONG ulShiftFreqScan;        // Disable Lock Shift in registry
    ULONG ulRelockMonitor;        // Relock Monitor enable flag
    //ULONG ulFreqMultiplier;       // Frequency Multiplier
    //ULONG ulSymRateMultiplier;    // Symbol rate Multiplier
    ULONG ulLNBLOF;               // Local Oscillator Frequency (LOF)
    ULONG ulLNBLOFLowBand;        // LOF Low Band
    ULONG ulLNBLOFHighBand;       // LOF High Band
    ULONG ulDiSEqC;               // DiSEqC Selection
    ULONG ulLNBPower;             // LNB Power ON/OFF
    ULONG ulTone;                 // Tone ON/OFF
    ULONG ulATSCFreqShift;        // ATSC frequency shift
} THBDAREGPARAMS, *PTHBDAREGPARAMS;

typedef struct {
	ULONG ulCIState;
    ULONG ulMMIState;
} THCIState, *PTHCIState;

typedef struct AppInfoStruct
{
	unsigned int app_type;
	unsigned int application_manufacture;
	unsigned int manufacture_code;
	char application_info[64];
} THAppInfo, *PTHAppInfo;

typedef struct MMIInfoStruct
{
	char Header[256];
	char SubHeader[256];
	char ButtomLine[256];
	char MenuItem[9][42];
	int  ItemCount;

	BOOL EnqFlag;

	BOOL Blind_Answer;
	int  Answer_Text_Length;
	char Prompt[256];

	int  Answer;
	char AnswerStr[256];

    int  Type;
} THMMIInfo, *PTHMMIInfo;

// Get driver info. IOCTL cmd structure
typedef struct DriverInfoStruct {
    BYTE Version_Major;         // in BCD Ex., 3.2    =====> 0x32
    BYTE Version_Minor;         //             2.1    =====> 0x21
    BYTE FW_Version_Major;      // in BCD Ex., 1.3    =====> 0x13
    BYTE FW_Version_Minor;      //             Beta03 =====> 0x03
    char Date_Time[22];         // Ex.,"2004-12-20 18:30:00" or  "DEC 20 2004 10:22:10"  with compiler __DATE__ and __TIME__  definition s
    char Company[8];            // Ex.,"TWINHAN" 
    char SupportHWInfo[32];     // Ex.,"PCI DVB CX-878 with MCU series", "PCI ATSC CX-878 with MCU series", "7020/7021 USB-Sat", , "7045/7046 USB-Ter",.....................
    char Reserved[190];
}THDRIVERINFO, *PTHDRIVERINFO;

typedef struct ParserPMTStruct {
	BYTE *pPMTData; // PMT section buffer data
	ULONG ulDataLen; // PMT section buffer length
	DWORD VPid;  // Discrambled Video PID
	DWORD APid;  // Discrambled Audio PID
	CAM_TYPE_ENUM CAM_Type; // CAM module type
}PARSERPMTINFO, *PPARSERPMTINFO;
