//  Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
//  This software is unpblished and contains the trade secrets and
//  confidential proprietary information of AMD. Unless otherwise provided
//  in the Software Agreement associated herewith, it is licensed in confidence
//  "AS IS" and is not to be reproduced in whole or part by any means except
//  for backup. Use, duplication, or disclosure by the Government is subject
//  to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
//  Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
//  Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
//  Sunnyvale, CA 94088.

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <dmiapi.h>
#include <io.h>
#include "dosins.h"

void mifEnableDisableDriver(char* pcDriverName,char* pcBfrStart,char cFiller)
{
  char* pcBfrTmp;
  pcBfrTmp=strstr(pcBfrStart,pcDriverName);
  if(pcBfrTmp!=NULL){
      while(*pcBfrTmp!='\n'&&pcBfrTmp>pcBfrStart)
          pcBfrTmp--;
      if(*pcBfrTmp=='\n')
          pcBfrTmp++;
      *pcBfrTmp++=cFiller;
      *pcBfrTmp  =cFiller;
      }
}

/*
**  The core idea for this function is to take a MIF file as input, combine it
**  with some values provided by either the system or the user, and write the
**  modified contents to a temporary file (usually on the user's hard disk).
**
**  This temporary file is then submitted to the DMI MIF compiler for
**  processing.
**
**  The modifications made to the file entail alterations to read-only PCNet
**  hardware and software attributes that are difficult to discern without
**  user input.
**
**  This  routine currently does not correctly handle MIF files that must be
**  processed using multiple reads of the source file (e.g. MIF files that
**  don't completely fit within the input buffer).
*/

TErrCode mifUpdateFile(
    TAtrVal*    ptAtrVals,
    char*       pcSrcPath,
    char*       pcDstPath,
    TDvr        tDvrType)
{
    char*       pcInputBfr=NULL;
    char*       pcInputBfrTmp;
    char*       pcNextWrite;
    FILE*       tFHIn=NULL;
    FILE*       tFHOut=NULL;
    TErrCode    tRetCode=errNoUpdate;
    unsigned    usToWrite;
    unsigned    usWritten;
    unsigned    len;
    unsigned    i;
    TBool       bSuccess=_false;
    TBool       bFirstPass=_true;
    char        tmpBfr[DOSPATHBFRLEN];

    // Open the MIF file.
    tFHIn=fopen(pcSrcPath,"r+");
    if(tFHIn==NULL)
      return errSrcOpenFail;
    // Verify the existence of the target directory.
    strncpy(tmpBfr,pcDstPath,i=my_strrchr(pcDstPath,'\\')-pcDstPath);
    tmpBfr[i]='\0';
    // If the target directory is the root, tmpBfr will contain exactly two
    // characters -- the driver letter and the ':' -- skip the existence
    // test. Otherwise check the existence of the target directory. If
    // it does not exist, return an error.
    if((strlen(tmpBfr)>2)&&!file_exists(tmpBfr)){
        tRetCode=errNoDir;
        goto muf_ErrExit;
        }
    // Create the output MIF file that will be passed to the MIF compiler.
    tFHOut=fopen(pcDstPath,"w+");
    if(tFHOut==NULL){
        tRetCode= errDstOpenFail;
        goto muf_ErrExit;
        }
    else {
        fseek(tFHIn,0L,SEEK_SET);
        // Allocate a buffer into which the MIF file can be read.
        if((pcInputBfr=malloc(SCANBFRLEN))==NULL){
            tRetCode=errNoBfr;
            goto muf_ErrExit;
            }
        else {
            while(!feof(tFHIn)){
                // pcNextWrite points to the next address in the input buffer
                // that must be written to the temporary file.
                pcNextWrite=pcInputBfr;
                // Try to read the whole MIF file.
                usWritten=fread(pcInputBfr,1,SCANBFRLEN-1,tFHIn);
                if(usWritten==0) goto muf_ErrExit;
                pcInputBfr[usWritten] = '\0';
                // Avoid case sensitivity issues.
//                strupr(pcInputBfr);
                // If installing for the ND3 driver, comment out the DOS
                // path to address an SL bug.
                if(bFirstPass){
                    bFirstPass=_false;
                    mifEnableDisableDriver(DOS_INSTR,pcInputBfr,
                      (char)(tDvrType==dosDvr?' ':'/'));
                    mifEnableDisableDriver(WIN_INSTR,pcInputBfr,
                      (char)(tDvrType==wfwDvr?' ':'/'));
                    mifEnableDisableDriver(OS2_INSTR,pcInputBfr,
                      (char)(tDvrType==os2Dvr?' ':'/'));
                    }
                pcInputBfrTmp = pcInputBfr;
//                pcInputBfrTmp = pcInputBfr+usWritten;
                while(*pcInputBfrTmp){
                    // Scan for the 'name' keyword. ScanInputBfr() leaves
                    // pcInputBfrTmp pointing at the character
                    // immediately following the '=' symbol.
                    len = ScanInputBfr(&pcInputBfrTmp,KW_NAME,t_str);
                    if(len){
                        // Each time the "Name" keyword is found, its value is
                        // compared to the names of the attributes being
                        // sought.
                        for(i=0;ptAtrVals[i].pcAtrName;i++){
                            if(strncmp(pcInputBfrTmp,ptAtrVals[i].pcAtrName,
                              len)==0){
                                pcInputBfrTmp+=len+1;
                                // Scan just beyond the next 'value' keyword.
                                len=ScanInputBfr(&pcInputBfrTmp,KW_VALUE,ptAtrVals[i].tType);
                                if(ptAtrVals[i].pcNewValue){
                                    // Write all the scanned text up to and
                                    // including the openning quotation mark of
                                    // the attribute's value.
                                    usWritten=fwrite(pcNextWrite,
                                        sizeof(char),
                                        usToWrite=(unsigned)(pcInputBfrTmp-pcNextWrite),
                                        tFHOut);
                                    if(usToWrite!=usWritten){
                                        tRetCode=errFWrite;
                                        goto muf_ErrExit;
                                        }
                                    // Update the ptr so the next write begins
                                    // at the closing quotation mark of the
                                    // attribute's value.
                                    pcNextWrite+=usWritten+len;
                                    // Write the new value to the temp file.
                                    usWritten=fwrite(ptAtrVals[i].pcNewValue,
                                        sizeof(char),
                                        usToWrite=strlen(ptAtrVals[i].pcNewValue),
                                        tFHOut);
                                    if(usToWrite!=usWritten){
                                        tRetCode=errFWrite;
                                        goto muf_ErrExit;
                                        }
                                    else {
                                        tRetCode=errOk;
                                        }
                                    break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        // Write the remainder of the buffer to the temporary file.
        usWritten=fwrite(pcNextWrite,
            sizeof(char),
            usToWrite=(unsigned)(pcInputBfrTmp-pcNextWrite),
            tFHOut);
        if(usToWrite!=usWritten) tRetCode=errFWrite;
muf_ErrExit:
        if(pcInputBfr!=NULL) free(pcInputBfr);
        if(tFHOut!=NULL) fclose(tFHOut);
        if(tFHIn!=NULL) fclose(tFHIn);
        return tRetCode;
        }
}
