/*
  (c) Copyright 1992 Eric Backus

  This software may be used freely so long as this copyright notice is
  left intact.  There is no warrantee on this software.
*/

#include <dos.h>		/* For REGS and intdos() */
#include <errno.h>		/* For errno */
#include <sys/vfs.h>		/* For statfs() */

/* From fixpath.c */
extern int	_get_default_drive(void);

/* An implementation of statfs() for DJGPP. */
int
statfs(const char *path, struct statfs *buf)
{
    union REGS		regs;
    int			drive_number;

    /* Get the drive number */
    if (path[0] >= 'a' && path[0] <= 'z' && path[1] == ':')
	drive_number = path[0] - 'a';
    else if (path[0] >= 'A' && path[0] <= 'Z' && path[1] == ':')
	drive_number = path[0] - 'A';
    else
	drive_number = _get_default_drive();

    /* Get free space info */
    regs.h.ah = 0x36;		/* DOS Get Free Disk Space call */
    regs.h.dl = drive_number + 1;
    (void) intdos(&regs, &regs);

    /* Check for errors */
    if ((regs.x.ax & 0xffff) == 0xffff)
    {
	errno = ENODEV;
	return -1;
    }

    /* Fill in the structure */
    buf->f_bavail = regs.x.bx;
    buf->f_bfree = regs.x.bx;
    buf->f_blocks = regs.x.dx;
    buf->f_bsize = regs.x.cx * regs.x.ax;
    buf->f_ffree = regs.x.bx;
    buf->f_files = regs.x.dx;
    buf->f_type = 0;
    buf->f_fsid[0] = drive_number;
    buf->f_fsid[1] = MOUNT_UFS;
    buf->f_magic = FS_MAGIC;

    return 0;
}
