#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <dos.h>
#include <dir.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <process.h>

#include "structs.h"

char default_dir[80], *default_fptr;
char install_dir[80], *install_fptr;
int disk_number = -1;
FileEntry *file_entries = 0;

FileEntry unzip_fe = {
  1, 1, 1,
  "unzip386.exe",
  0, "Unzip",
  0
};

#include "ansi.h"
#include "query.h"
#include "select.h"
#include "diskutil.h"
#include "loaddat.h"
#include "yesno.h"
#include "unzip.h"

main(int argc, char **argv)
{
  long free_space;
  char *cp, *cp2;
  char buffer[100];
  FileEntry *fe;
  int i;
  int auto_desire = 0;

  setbuf(stdout, 0);
  ansidetect();
  ansi("\033[0m");

  if (argc < 1)
    exit(1);
  printf("Executing %s\n", argv[0]);

  strcpy(default_dir, argv[0]);
  cp = default_dir;
  for(cp2 = default_dir; *cp2; cp2++)
    if (*cp2 == '/' || *cp2 == '\\' || *cp2 == ':')
      cp = cp2+1;
  default_fptr = cp;

  load_data_file();
  sort_data_file(1);
  show_data_file();

  do {
    query("Directory to install in : ", install_dir, "c:/djgpp");
    free_space = show_free_space();
    
    if (yesno("Use this disk/directory") == 'n')
      continue;
  
    if (mmkdir(install_dir))
      printf("Cannot create that directory.  Please specify another.\n");
    else
      break;
  } while (1);

  while (1)
  {
    long space_used = 0;
    for (fe=file_entries; fe; fe=fe->next)
    {
      printf("\nModule: %s%s%s   size: %s%s   ",
             ansibold, fe->file_name, ansinorm,
             ansibold, kb(fe->size_uncompressed), ansibold);
      ansi("\033[32m");
      printf("%s%s\n", fe->description, ansinorm);
      if (fe->mandatory)
      {
        ansi("\033[1;33m");
        printf("This module is mandatory.%s\n", ansinorm);
        fe->desired = 1;
      }
      else if (space_used + fe->size_uncompressed > free_space)
      {
        ansi("\033[1;34m");
        printf("There is not enough space for this module.%s\n", ansinorm);
        fe->desired = 2;
      }
      else
      {
        if (auto_desire)
          fe->desired = auto_desire;
        else
          fe->desired = select(fe->desired, "", "Install", "Skip", "Install remainder", "Skip remainder", 0);
        if (fe->desired == 3)
        {
          fe->desired = 1;
          auto_desire = 1;
        }
        if (fe->desired == 4)
        {
          fe->desired = 2;
          auto_desire = 2;
        }
      }
      if (fe->desired == 1)
        space_used += fe->size_uncompressed;
      if (space_used > free_space)
      {
        printf("\n%sThere is not enough disk space on this drive to install\n", ansibold);
        printf("The mandatory parts of djgpp.  Please free up space or\n");
        printf("install on a different drive.%s\n", ansinorm);
        exit(1);
      }
      printf("You have used %s%s%s of space. ", ansibold, kb(space_used), ansinorm);
      printf("There is %s%s%s of space remaining.\n", ansibold, kb(free_space - space_used), ansinorm);
    }
    show_data_file();
    if (yesno("Would you like to change anything") == 'n')
      break;
    auto_desire = 0;
  }

  sort_data_file(0);

  *install_fptr = 0;
  if (install_dir[1] == ':')
    setdisk((install_dir[0]& 0x1f) - 1);
  if (chdir(install_dir))
  {
    printf("can't change directories to %s\n", install_dir);
    exit(1);
  }

  unzip(&unzip_fe, 0);

  for (fe=file_entries; fe; fe=fe->next)
    if (fe->desired == 1)
      unzip(fe, 1);
  remove("unzip386.exe");
  return 0;
}
