int entry_compare_dn(void *va, void *vb)
{
  FileEntry *a = *(FileEntry **)va;
  FileEntry *b = *(FileEntry **)vb;
  if (a->disk_no != b->disk_no)
    return a->disk_no - b->disk_no;
  return strcmp(a->file_name, b->file_name);
}

int entry_compare_n(void *va, void *vb)
{
  FileEntry *a = *(FileEntry **)va;
  FileEntry *b = *(FileEntry **)vb;
  return strcmp(a->file_name, b->file_name);
}

void load_data_file()
{
  FileEntry *last_entry = 0, *fe;
  char line[1000], fname[80];
  FILE *dat_file;
  int i;
  FileEntry **felist;

  strcpy(default_fptr, "INSTALL.DAT");
  printf("Loading %s\n", default_dir);
  dat_file = fopen(default_dir, "r");
  if (dat_file == 0)
  {
    printf("Cannot load %s!\n", default_dir);
    exit(1);
  }
  while (fgets(line, 1000, dat_file))
  {
    if (!isdigit(line[0]))
      continue;
    line[strlen(line)-1] = 0; /* strip NL */
      
    fe = (FileEntry *)malloc(sizeof(FileEntry));
    sscanf(line, "%d %c %s %ld %n\n",
      &(fe->disk_no),
      &(fe->mandatory),
      fname,
      &(fe->size_uncompressed),
      &i);
    fe->description = strdup(line+i);
    fe->mandatory = (fe->mandatory == 'y') || (fe->mandatory == 'Y');
    fe->desired = 0;
    fe->file_name = strdup(fname);
    fe->next = 0;
    
    if (last_entry)
      last_entry->next = fe;
    else
      file_entries = fe;
    last_entry = fe;
  }
  fclose(dat_file);
}

void sort_data_file(int byname)
{
  int c, i;
  FileEntry *fe, **felist;
  if (file_entries == 0)
    return;
  for (c=0, fe=file_entries; fe; fe=fe->next)
    c++;
  felist = (FileEntry **)malloc(c * sizeof(FileEntry *));
  for (i=0, fe=file_entries; fe; fe=fe->next, i++)
    felist[i] = fe;
  qsort(felist, c, sizeof(FileEntry *), byname ? entry_compare_n : entry_compare_dn);
  for (i=0; i<c-1; i++)
    felist[i]->next = felist[i+1];
  felist[i]->next = 0;
  file_entries = felist[0];
  free(felist);
}

void show_data_file(void)
{
  FileEntry *fe;
  int count = 0;
  printf("\nContents of distribution (M=Mandatory, I=Installing):\n");
  for (fe=file_entries; fe; fe=fe->next)
  {
    if (count == 0)
    {
      printf("Disk M I Name          Size   Description\n");
      count = 20;
    }
    ansi(ansibold);
    if (fe->mandatory)
      ansi("\033[33m");
    if (fe->desired == 1)
      ansi("\033[32m");
    if (fe->desired == 2)
      ansi("\033[0m");
    if (fe->disk_no)
      printf("%4d", fe->disk_no);
    else
      fputs("    ", stdout);
    printf(" %c %c %-12s",
      "NY"[fe->mandatory],
      "?YN"[fe->desired],
      fe->file_name);
    printf(" %s %s\n", kb(fe->size_uncompressed), fe->description);
    ansi(ansinorm);
    if (--count == 0)
    {
      printf("<Space> for next screen, <Escape> to end listing : ");
      while (1)
      {
        int c = getch();
        if (c == ' ')
        {
          printf("More!\n");
          break;
        }
        else if (c == 27)
        {
          printf("Skip\n");
          printf("\n");
          return;
        }
        else
        {
          putchar(7);
          break;
        }
      }
    }
  }
  printf("\n");
}
