*** orig/texinfo-.1/info/pc_term.c	Sun Aug 29 18:41:06 1993
--- src/texinfo-.1/info/pc_term.c	Thu Jul 21 01:11:48 1994
***************
*** 0 ****
--- 1,171 ----
+ /* pc_term.c */
+ 
+ /* This file is part of the MSDOS-DJGPP-port of the GNU standalone
+    Info-reader
+ 
+    This program is free software; you can redistribute it and/or modify
+    it under the terms of the GNU General Public License as published by
+    the Free Software Foundation; either version 2, or (at your option)
+    any later version.
+ 
+    This program is distributed in the hope that it will be useful,
+    but WITHOUT ANY WARRANTY; without even the implied warranty of
+    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+    GNU General Public License for more details.
+ 
+    You should have received a copy of the GNU General Public License
+    along with this program; if not, write to the Free Software
+    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
+ 
+  */
+ 
+ #include <stdio.h>
+ #include <pc.h>
+ #include <gppconio.h>
+ #include "pc_term.h"
+ #include "terminal.h"
+ #include "termdep.h"
+ 
+ #define max(x,y) ((x)>(y) ? (x) : (y))
+ #define min(x,y) ((x)<(y) ? (x) : (y))
+ #define keywait  do {char dummy=0;\
+                      fflush(stdout);\
+                      while (!kbhit()) ;\
+                      dummy=getkey();\
+                  } while (0);
+ 
+ static struct text_info pc_info; /* struct to hold the conio-status */
+ 
+ void pc_begin_inverse()
+ {
+     textbackground(7);
+     textcolor(0);
+ }
+ 
+ void pc_end_inverse()
+ {
+     textbackground(0);
+     textcolor(7);
+ }
+ 
+ void pc_prep_terminal()
+ {
+   textattr(0x07);
+ }
+ 
+ void pc_unprep_terminal()
+ {
+     ScreenClear(); /* to leave behind a clean screen */
+ }
+ 
+ void pc_up_line()
+ {
+     int x, y;
+     ScreenGetCursor(&y, &x);
+     ScreenSetCursor(max(y-1, 0), x);
+ }
+ 
+ void pc_down_line()
+ {
+     int x, y;
+     ScreenGetCursor(&y, &x);
+     ScreenSetCursor(min(screenheight-1, y+1), x);
+ }
+ 
+ void pc_clear_screen()
+ {
+     ScreenClear();
+ }
+ 
+ void pc_clear_to_eol()
+ {
+     clreol(); /* perhaps to be replaced by a loop */
+ }
+ 
+ void pc_get_screen_size()
+ {
+     screenwidth  = ScreenCols();
+     screenheight = ScreenRows();
+ }
+ 
+ void pc_goto_xy(x, y)
+ int x, y;
+ {
+     ScreenSetCursor(y, x); /* yes, pc.h says ...(row, column) !! */
+ }
+ 
+ void pc_initialize_terminal(term_name)
+     char *term_name;
+ {
+     gppconio_init();
+     gettextinfo(&pc_info);
+     screenwidth  = ScreenCols();
+     screenheight = ScreenRows();
+ }
+ 
+ void pc_new_terminal(term_name)
+     char *term_name;
+ {
+     pc_initialize_terminal(term_name);
+ }
+ 
+ void pc_put_text(string)
+ char *string;
+ {
+     cputs(string);
+ }
+ 
+ void pc_ring_bell()
+ {
+     printf("%c",'\a');
+ }
+ 
+ void pc_write_chars(string, nchars)
+     char *string;
+     int nchars;
+ {
+     cprintf("%.*s",nchars, string);
+ }
+ 
+ void pc_scroll_terminal(start, end, amount)
+     int start, end, amount;
+ {
+     movetext(pc_info.winleft, start, pc_info.winright, end,
+         pc_info.winleft, start+amount);
+ }
+ 
+ int       tputs(char *a, int b, int (*c)())
+ {
+   perror("tputs");
+ }
+ 
+ char*     tgoto(char*a, int b, int c)
+ {
+   perror("tgoto");
+ }
+ 
+ int       tgetnum(char*a)
+ {
+   perror("tgetnum");
+ }
+ 
+ int       tgetflag(char*a)
+ {
+   perror("tgetflag");
+ }
+ 
+ char*     tgetstr(char *a, char **b)
+ {
+   perror("tgetstr");
+ }
+ 
+ int       tgetent(char*a, char*b)
+ {
+   perror("tgetent");
+ }
+ 
+ int       sigblock(int a)
+ {
+   return 0;
+ }
+ 
