/*----------------------------------------------------------------------
 *
 *  curses.h
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  header file for Curses!
 *
 *  correspondence to:
 *
 * J. Alan Eldridge
 * Liberty Brokerage
 * 77 Water St.
 * New York, NY 10005
 * 
 *----------------------------------------------------------------------
 */

#ifndef __CURSES__

#define __CURSES__

#define CURSES_MAJOR_VERSION 3
#define CURSES_MINOR_VERSION 0

#ifndef __GNUC__

/*
    get the compiler header files we need
*/
    
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

#include "compiler.h"   /* define compilation environment */

#ifndef __UCHAR_DEFINED__
#define __UCHAR_DEFINED__   1
typedef unsigned char   UCHAR;  /* because I use it a lot */
typedef signed char     SCHAR;  /* because we have UCHAR */
#endif  /* __UCHAR_DEFINED__ */

#else

#include    "aedef.h"
#include    <pc.h>

#define far

#endif

typedef struct {
    UCHAR   chr,    /* each character in the PC video buffer ... */
            att;    /* ... is represented by a char, attribute pair */
} VIDCHR;

struct curses_v3_window;    /* create the name so I can typedef */

typedef struct curses_v3_window WINDOW; /* use WINDOW from now on */

struct curses_v3_window {
    int     cury, curx,     /* logical cursor position */
            maxy, maxx,     /* lower right hand corner */
            orgy, orgx,     /* upper left hand corner */
            attrib,         /* current video attribute */
            s_attr,         /* "standout" video attribute */
            n_attr,         /* "normal" video attribute */
            b_attr,         /* "bright" video attribute */
            flags,          /* see below for values */
            firsty,         /* first line not updated on screen */
            lasty,          /* last line not updated on screen */
            *firstx,        /* array of ints: first x on line not updated */
            *lastx;         /* array of ints: last x on line not updated */
    VIDCHR  **buf;          /* array of ptrs to screen buffer, 1 per line */
    UCHAR   appl_info[4];   /* for application use */
    WINDOW  *next,          /* in case I want to link windows ... */
            *prev;          /* ... in some kind of front-to-back list */
    UCHAR   reserved[16];   /* in case I need something internally ... */
};

/*
    miscellaneous structures
*/
    
typedef struct {
    UCHAR   model;
    UCHAR   submodel;
}   MACHINE_ID;

typedef union {
    unsigned long       longval;
    void far            *farptr;
    struct {
        short   offs;
        short   seg;
    }                   segoffs;
}   FAR_PTR_UNION;    

/*
    these are the rest of the Curses! include files
*/
    
#include "pckeybd.h"
#include "pcvideo.h"
#include "pmenuobj.h"

#include "curses.pro"

/* 
    global variables
*/
    
extern  WINDOW  *stdscr,        /* default window */
                *curscr;        /* screen image window */

extern  int     LINES,          /* # rows on physical screen */
                COLS,           /* # cols on physical screen */
                __USE_BIOS,     /* use video BIOS calls? */
                __DEFNORM,      /* default "normal" attribute */
                __DEFSTAND,     /* default "standout" attribute */
                __DEFBRIGHT,    /* default "bright" attribute */
                __VIDMODE;      /* current video mode from BIOS */
                
extern MACHINE_ID       __MACHID;   /* machine ID from ROM */

extern FAR_PTR_UNION    __VIDADDR;  /* far ptr to video RAM */

/*
    miscellaneous constants 
*/

#define TRUE    1
#define FALSE   0

#define OK      0
#define ERR     -1

/*
    values for WINDOW.flags bits
*/
    
#define _WCLEAR     0x0001
#define _WLEAVE     0x0002
#define _WSCROLL    0x0004
#define _WWRAP      0x0008
#define _WSUBWIN    0x0010
#define _WFULLWIN   0x0020
#define _WBOX       0x0040
#define _WDIRTY     0x0080

/*
    macro to determine the # of elements in an array
*/

#define NUM_ARRAY_ELEMS(arr)    (sizeof(arr)/sizeof((arr)[0]))

/*---------------------------------------------------------------------
 *
 *    macros that look like functions
 *
 *---------------------------------------------------------------------
 */
    
/* these macros use internal function calls */

#define flushinp()          while(_kb_look())_kb_read()
#define scroll(w)           _scroll((w),0,getmaxr(w),1)
#define scrollwin(w,l)      _scroll((w),0,getmaxr(w),l)
#define wdeleteln(w)        _scroll((w),(w)->cury,getmaxr(w),1)
#define winsertln(w)        _scroll((w),(w)->cury,getmaxr(w),-1)

/* these macros are abbreviations for longer calling sequences */

#define addch(c)            waddch(stdscr,c)
#define addstr(s)           waddstr(stdscr,s)
#define beep()              putchar(7)           
#define brightoff()         wbrightoff(stdscr)
#define brighton()          wbrighton(stdscr)
#define blinkoff()          wblinkoff(stdscr)
#define blinkon()           wblinkon(stdscr)
#define centstr(r,s)        wcentstr(stdscr,r,s)
#define clear()             wclear(stdscr)
#define clrtobot()          wclrtobot(stdscr)
#define clrtoeol()          wclrtoeol(stdscr)
#define delch()             wdelch(stdscr)
#define deleteln()          wdeleteln(stdscr)
#define editfld(b,n,t,i,s,f,z)      weditfld(stdscr,b,n,t,i,s,f,z)
#define edittxt(b,n,t,i,s,f,z,p)    wedittxt(stdscr,b,n,t,i,s,f,z,p)
#define egetstr(b)          wegetstr(stdscr,b)
#define erase()             werase(stdscr)
#define getch()             wgetch(stdscr)
#define getstr(s)           wgetstr(stdscr,s)
#define getattr(win)        ((win)->attrib & 0xff)
#define getbright(win)      ((win)->b_attr & 0xff)
#define getnorm(win)        ((win)->n_attr & 0xff)
#define getorg(win,y,x)     ((y)=getorgy(win),(x)=getorgx(win))
#define getorgx(win)        ((win)->orgx)
#define getorgy(win)        ((win)->orgy)
#define getmaxc(win)        ((win)->maxx)
#define getmaxr(win)        ((win)->maxy)
#define getmaxrc(win,r,c)   ((r)=getmaxr(win),(c)=getmaxc(win))
#define getstand(win)       ((win)->s_attr & 0xff)
#define getyx(win,y,x)      ((y)=(win)->cury,(x)=(win)->curx)
#define hasbox(win)         ((win)->flags & _WBOX)
#define inat()              winat(stdscr)
#define inch()              winch(stdscr)
#define insch(c)            winsch(stdscr, c)
#define insertln()          winsertln(stdscr)
#define iscolor()           (__VIDMODE != VID_MONO_80x25)
#define move(r,c)           wmove(stdscr,r,c)
#define mvaddch(r,c,ch)     (move(r,c),addch(ch))
#define mvaddstr(r,c,str)   (move(r,c),addstr(str))
#define mvcur(ly,lx,y,x)    vid_mov_curs(y,x)
#define mvdelch(r,c)        (move(r,c),delch())
#define mvdrawbox(win,r,c,y,x,v,h)      (wmove(win,r,c),drawbox(win,y,x,v,h))
#define mveditfld(r,c,b,n,t,i,s,f,z)    (move(r,c),editfld(b,n,t,i,s,f,z))
#define mveditstr(r,c,b,n)              (move(r,c),editstr(b,n))
#define mvedittxt(r,c,b,n,t,i,s,f,z,p)  (move(r,c),editfld(b,n,t,i,s,f,z,p))
#define mvegetstr(r,c,b)                (move(r,c),egetstr(b))
#define mvgetch(r,c)        (move(r,c),getch())
#define mvgetstr(r,c,s)     (move(r,c),getstr(s))
#define mvinat(r,c)         (move(r,c),inat())
#define mvinch(r,c)         (move(r,c),inch())
#define mvinsch(r,c,ch)     (move(r,c),insch(ch))
#define mvwaddch(win,r,c,ch)            (wmove(win,r,c),waddch(win,ch))
#define mvwaddstr(win,r,c,s)            (wmove(win,r,c),waddstr(win,s))
#define mvwdelch(win,r,c)               (wmove(win,r,c),wdelch(win))
#define mvweditfld(w,r,c,b,n,t,i,s,f,z) (wmove(w,r,c),weditfld(w,b,n,t,i,s,f,z))
#define mvweditstr(w,r,c,b,n)           (wmove(w,r,c),weditstr(w,b,n))
#define mvwedittxt(w,r,c,b,n,t,i,s,f,z,p) \
    (wmove(w,r,c),weditfld(w,b,n,t,i,s,f,z,p))
#define mvwegetstr(w,r,c,b)     (wmove(w,r,c),wegetstr(w,b))
#define mvwgetch(win,r,c)       (wmove(win,r,c),wgetch(win))
#define mvwgetstr(win,r,c,s)    (wmove(win,r,c),wgetstr(win,s))
#define mvwinat(win,r,c)        (wmove(win,r,c),winat(win))
#define mvwinch(win,r,c)        (wmove(win,r,c),winch(win))
#define mvwinsch(win,r,c,ch)    (wmove(win,r,c),winsch(win,ch))
#define refresh()           wrefresh(stdscr)
#define setattr(w,a)        ((w)->attrib = (a))
#define setbright(w,a)      ((w)->b_attr = (a))
#define setnorm(w,a)        ((w)->n_attr = (a))
#define setstand(w,a)       ((w)->s_attr = (a))
#define standend()          wstandend(stdscr)
#define standout()          wstandout(stdscr)
#define use_vid_bios(flag)  (__USE_BIOS=(flag))
#define wblinkoff(win)      ((win)->attrib &= 0x7f)
#define wblinkon(win)       ((win)->attrib |= 0x80)
#define wbrightoff(win)     wstandend(win)
#define wbrighton(win)      ((win)->attrib = (win)->b_attr)
#define winat(win)          ((win)->buf[(win)->cury][(win)->curx].att)
#define winch(win)          ((win)->buf[(win)->cury][(win)->curx].chr)
#define wstandend(win)      ((win)->attrib = (win)->n_attr)
#define wstandout(win)      ((win)->attrib = (win)->s_attr)

#endif  /* __CURSES */
