/**********************************************************************
 *  
 *  NAME:           libae.h
 *  
 *  DESCRIPTION:    defs, prototypes for libae.a
 *  
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  10/27/91    J. Alan Eldridge    created
 *  
 *********************************************************************/

#ifndef __LIBAE_H
#define __LIBAE_H

#ifdef  __cplusplus
extern "C" {
#endif    

extern int clockinmsec(void);

extern int getch(void);

extern void delay(int msec);

#define nosound()   sound(0)

#ifdef  __cplusplus
}
#endif    

#ifndef CHAR_MAX
#define     UCHAR_MAX   (0xff)
#define     UCHAR_MIN   0
#define     SCHAR_MAX   (0x7f)
#define     SCHAR_MIN   (0x80)
#define     CHAR_MAX    SCHAR_MAX
#define     CHAR_MIN    SCHAR_MIN
#endif

#ifndef SHRT_MAX
#define     SHRT_MAX    (0x7fff)
#define     SHRT_MIN    (0x8000)
#define     USHRT_MAX   (0xffff)
#define     USHRT_MIN   (0x0000)
#endif

#ifndef INT_MAX
#define     INT_MAX     LONG_MAX
#define     UINT_MAX    ULONG_MAX
#define     INT_MIN     LONG_MIN
#define     UINT_MIN    ULONG_MIN
#endif

#endif
