CFLAGS = -c -ml -v

CC = tcc $(CFLAGS)

HFILES = curses.h pcvideo.h pckeybd.h pmenuobj.h compiler.h

OBJECTS =   alert.obj       curses.obj      kbgetc.obj      newwin.obj      \
            spooler.obj     wgetstr.obj     curstype.obj    line.obj        \
            overlay.obj     teechar.obj     winflags.obj    box.obj         \
            cvidintf.obj    machine.obj     pmenuobj.obj    waddstr.obj     \
            winsch.obj      boxwin.obj      delwin.obj      markwin.obj     \
            popmenu.obj     wcentstr.obj    wrefresh.obj    calcpopy.obj    \
            drawbox.obj     matchkey.obj    printw.obj      wclrtoeo.obj    \
            ckbdintf.obj    expldwin.obj    memsetw.obj     savescr.obj     \
            wdelch.obj      cornerch.obj    kbbgtask.obj    mvwin.obj       \
            scroll.obj      werase.obj

all: tcurses.lib

alert.obj   :   alert.c $(HFILES)
    $(CC)   alert.c

boxwin.obj  :   boxwin.c $(HFILES)
    $(CC)   boxwin.c

cornerch.obj:   cornerch.c $(HFILES)
    $(CC)   cornerch.c

drawbox.obj :   drawbox.c $(HFILES)
    $(CC)   drawbox.c

expldwin.obj:   expldwin.c $(HFILES)
    $(CC)   expldwin.c

line.obj    :   line.c $(HFILES)
    $(CC)   line.c

mvwin.obj   :   mvwin.c $(HFILES)
    $(CC)   mvwin.c

popmenu.obj :   popmenu.c $(HFILES)
    $(CC)   popmenu.c

pmenuobj.obj:   pmenuobj.c $(HFILES)
    $(CC)   pmenuobj.c

box.obj     :   box.c $(HFILES)
    $(CC)   box.c

calcpopy.obj:   calcpopy.c $(HFILES)
    $(CC)   calcpopy.c

printw.obj  :   printw.c $(HFILES)
    $(CC)   printw.c

savescr.obj :   savescr.c $(HFILES)
    $(CC)   savescr.c

overlay.obj :   overlay.c $(HFILES)
    $(CC)   overlay.c

spooler.obj :   spooler.c $(HFILES)
    $(CC)   spooler.c

kbbgtask.obj:   kbbgtask.c $(HFILES)
    $(CC)   kbbgtask.c

teechar.obj :   teechar.c $(HFILES)
    $(CC)   teechar.c

wcentstr.obj:   wcentstr.c $(HFILES)
    $(CC)   wcentstr.c

wdelch.obj  :   wdelch.c $(HFILES)
    $(CC)   wdelch.c

werase.obj  :   werase.c $(HFILES)
    $(CC)   werase.c

wgetstr.obj :   wgetstr.c $(HFILES)
    $(CC)   wgetstr.c

matchkey.obj:   matchkey.c $(HFILES)
    $(CC)   matchkey.c

waddstr.obj :   waddstr.c $(HFILES)
    $(CC)   waddstr.c

winflags.obj:   winflags.c $(HFILES)
    $(CC)   winflags.c

winsch.obj  :   winsch.c $(HFILES)
    $(CC)   winsch.c

curses.obj  :   curses.c $(HFILES)
    $(CC)   curses.c

curstype.obj:   curstype.c $(HFILES)
    $(CC)   curstype.c

delwin.obj  :   delwin.c $(HFILES)
    $(CC)   delwin.c

kbgetc.obj  :   kbgetc.c $(HFILES)
    $(CC)   kbgetc.c

ckbdintf.obj:   ckbdintf.c $(HFILES)
    $(CC)   ckbdintf.c

machine.obj :   machine.c $(HFILES)
    $(CC)   machine.c

newwin.obj  :   newwin.c $(HFILES)
    $(CC)   newwin.c

wclrtoeo.obj:   wclrtoeo.c $(HFILES)
    $(CC)   wclrtoeo.c

scroll.obj  :   scroll.c $(HFILES)
    $(CC)   scroll.c

wrefresh.obj:   wrefresh.c $(HFILES)
    $(CC)   wrefresh.c

cvidintf.obj:   cvidintf.c $(HFILES)
    $(CC)   cvidintf.c

markwin.obj :   markwin.c $(HFILES)
    $(CC)   markwin.c

memsetw.obj :   memsetw.c $(HFILES)
    $(CC)   memsetw.c

tcurses.lib:    $(OBJECTS)
    tlib tcurses.lib @tcurses.bld 

