/*------------------------------------------------------------
 * 
 *  overlay.c
 * 
 *  overlay/overwrite one window onto another
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *----------------------------------------------------------*/

#include "curses.h"

#define MIN(a,b) (a) < (b) ? (a) : (b)
#define MAX(a,b) (a) > (b) ? (a) : (b)

static int
over(win1, win2, zap)
WINDOW *win1, *win2;
char zap;
{
    VIDCHR **buf1,  **buf2;
    int orgy, orgx, org1y, org1x, org2y, org2x, maxy, maxx, max1y, max1x,
        max2y, max2x, pos1y, pos1x, pos2y, pos2x, cursy, cursx;

    /* convert to global & intersect */

    orgy = MAX(win1->orgy, win2->orgy);
    orgx = MAX(win1->orgx, win2->orgx);
    maxy = MIN(win1->orgy + win1->maxy, win2->orgy + win2->maxy);
    maxx = MIN(win1->orgx + win1->maxx, win2->orgx + win2->maxx);
  
    /* if no intersection, done */
    if (orgy > maxy || orgx > maxx)
        return OK;

    /* convert back to local */
    org1y = orgy - win1->orgy;
    org1x = orgx - win1->orgx;
    org2y = orgy - win2->orgy;
    org2x = orgx - win2->orgx;
    max1y = maxy - win1->orgy;
    max1x = maxx - win1->orgx;
    max2y = maxy - win2->orgy;
    max2x = maxx - win2->orgx;

    /* set up ptrs */
    buf1 = win1->buf;
    buf2 = win2->buf;

    /* save cursor pos & mark starting pt */
    getyx(win2, cursy, cursx);
    wmove(win2, org2y, org2x);
    markwin(win2);

    /* copy */
    pos1y = org1y;
    pos2y = org2y;

    while (pos1y <= max1y) {
        pos1x = org1x;
        pos2x = org2x;
        while (pos1x <= max1x) {
            if (zap || buf1[pos1y][pos1x].chr != ' ') 
                buf2[pos2y][pos2x] = buf1[pos1y][pos1x];
            pos1x++;
            pos2x++;
        }
        pos1y++;
        pos2y++;
    }

    /* mark ending pt & restore cursor pos */
    wmove(win2, max2y, max2x);
    markwin(win2);
    wmove(win2, cursy, cursx);
    
    return OK;
}

int
overlay(win1, win2)
WINDOW *win1, *win2;
{
  return over(win1, win2, 1);
}

int
overwrite(win1, win2)
WINDOW *win1, *win2;
{
    return over(win1, win2, 0);
}

