/*------------------------------------------------------------
 * 
 *  werase.c
 * 
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  erase/clear a window
 * 
 *----------------------------------------------------------*/

#include "curses.h"

int
werase(win)
WINDOW *win;
{
    VIDCHR fillch;
    int y;
	
    fillch.chr = ' ';
    fillch.att = win->attrib;
	
    for (y = 0; y <= win->maxy; y++)
        memsetw(win->buf[y], &fillch, getmaxc(win)+1);
    touchwin(win);
    wmove(win,0,0);
    win->flags &= ~_WBOX;

    return OK;
}
	
int
wclear(win)
WINDOW *win;
{
    win->flags |= _WCLEAR;
    return werase(win);
}

