/**********************************************************************
 *  
 *  NAME:           aecc.h
 *  
 *  DESCRIPTION:    include common compiler headers
 *  
 *  This file is placed in the public domain.
 *
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  11/11/90    J. Alan Eldridge    created
 *  
 *  12/23/90    JAE                 simplified conditionals a bit,
 *                                  added new.h for TC++ 1.90 
 *
 *********************************************************************/

#if !defined(__AECC_H)

#define __AECC_H    1

/**********************************************************************
 *  
 *  version # for TC++ 1.0, TC++ 1.90 beta
 *  
 *********************************************************************/

#define CPP100VER   0x295   /*  should be 0x0100    */
#define CPP190VER   0x297   /*  should be 0x0190    */

/**********************************************************************
 *
 *  we always want the basic ANSI .h files
 *  
 *********************************************************************/

#if defined(__GNUG__) || defined(__GNUC__)

#define _CLOCK_T_   long

#endif

#include    <ctype.h>
#include    <errno.h>
#include    <limits.h>
#include    <setjmp.h>
#include    <stdarg.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <time.h>

#if defined(__GNUG__) || defined(__GNUC__)

#include    <unistd.h>
#include    "libae.h"

#ifdef  __cplusplus
extern "C" int  atexit(void (*)());
#else
extern int      atexit(void (*)());
#endif

#endif

/**********************************************************************
 *  
 *  the rest of these .h files are special purpose
 *  
 *  their inclusion is controlled by preprocessor defines:
 *  
 *  symbol          files
 *  ------------------------------------------------------------
 *  INCL_DOS        bios.h,dos.h,dir.h
 *  
 *  INCL_CONIO      conio.h
 *  
 *  INCL_MEM        mem.h,alloc.h,new.h (TC++ 1.90 only)
 *  
 *  INCL_IOSTREAM   iostream.h,iomanip.h,fstream.h
 *
 *  INCL_FILEIO     fcntl.h,io.h,sys/stat.h
 *                  share.h
 *  
 *********************************************************************/

/*  DOS/BIOS interface  */
#if INCL_DOS
#include    <bios.h>
#include    <dos.h>
#include    <dir.h>
#endif  /*  INCL_DOS    */

/*  TURBO C++ console io    */
#if INCL_CONIO

#if     defined(__TURBOC__)
#include    <conio.h>
#elif   defined(__GNUG__) || defined(__GNUC__)
#include    <pc.h>
#include    <gppconio.h>
#endif

#endif  /*  INCL_CONIO  */

/*  memory allocation   */
#if INCL_MEM
#if defined(__cplusplus) && __TURBOC__ >= CPP190VER
#include    <new.h>
#endif
#include    <mem.h>
#include    <alloc.h>
#endif  /*  INCL_MEM    */

/*  C++ 2.0 streams */
#if INCL_IOSTREAM && defined(__cplusplus)
#include    <iostream.h>
#include    <iomanip.h>
#include    <fstream.h>
#endif  /*  INCL_IOSTREAM   */

/*  low-level (read(),write()) file io  */
#if INCL_FILEIO
#include    <fcntl.h>
#include    <io.h>
#include    <sys/stat.h>
#include    <share.h>
#endif  /*  INCL_FILEIO */

#endif  /*  !defined(__AECC_H)  */
