/**********************************************************************
 *  
 *  NAME:           grafchrs.c
 *  
 *  DESCRIPTION:    arrays of line drawing chars
 *  
 *  copyright (c) 1990 J. Alan Eldridge
 * 
 *  M O D I F I C A T I O N   H I S T O R Y
 *
 *  when        who                 what
 *  -------------------------------------------------------------------
 *  05/27/90    J. Alan Eldridge    created from line, cornerch, teechar
 *  
 *  12/01/90    JAE                 modified for Uwin 2.0
 *
 *********************************************************************/

#include    "aedef.h"

/**********************************************************************
 *
 *  corner characters
 *
 *  UWCornerChars [n] [v] [h]
 *
 *  v & h are 0 for single line, 1 for double,
 *  n is location as per the following diagram:
 *
 *      0   1
 *
 *      3   2
 *
 *********************************************************************/

uchar UWCornerChars [][2][2] = {
    218, 213, 
    214, 201, 

    191, 184, 
    183, 187,

    217, 190, 
    189, 188,

    192, 212, 
    211, 200
};

/**********************************************************************
 *
 *  line drawing chars
 *
 *  UWLineChars [n] [h_or_v]
 *
 *  h_or_v is 0 for horizontal, 1 for vertical
 *  n is 0 for single line, 1 for double line
 *
 *********************************************************************/

uchar UWLineChars [][2] = {
    196, 179,
    205, 186
};

/**********************************************************************
 *  
 *  graphic chars used to create a complex box type display
 *
 *  UWTeeChars [n] [v] [h] 
 *  
 *  the positions on the box are numbered like this:
 *
 *          0
 *             
 *      3   4   1
 *
 *          2
 *
 *  therefore the characters are shaped like this (0 to 4):
 *
 *      ---          | 
 *       |    --|   ---   |--   -|-
 *
 *  v & h are 0 for single lines, 1 for double lines
 *
 *********************************************************************/

uchar UWTeeChars [][2][2] = {
    194, 209, 
    210, 203,

    180, 181, 
    182, 185,

    193, 207, 
    208, 202,

    195, 198, 
    199, 204,

    197, 216, 
    215, 206
};


