#include "fntool.h"
#ifdef __GNUC__
#include <sys/file.h>
#endif
#ifdef __TURBOC__
#define  F_OK	0
#endif

static void loadfont(char *name)
{
	char *p;
	int  type = opt.intype;

	if(type == UNK) {
	    if((p = strrchr(name,'.')) == NULL) type = FNT;
	    else if(strmatch(p,".bdf")) type = BDF;
	    else if(strmatch(p,".fna")) type = FNA;
	    else if(strmatch(p,".fnt")) type = FNT;
	    else if(strmatch(p,".c"))	type = _C_;
	    else type = FNT;
	}
	openinput(name,(type == FNT) ? "rb" : "r");
	if(opt.verbose) {
	    printf("  reading \"%s\"...\t",inname);
	    fflush(stdout);
	}
	memset(&fnt,0,sizeof(font));
	notes[0] = '\0';
	strcpy(fnt.name,name);
	if((p = strrchr(fnt.name,'.')) != NULL) *p = '\0';
	switch(type) {
	    case BDF: readbdf(); break;
	    case FNA: readfna(); break;
	    case FNT: readfnt(); break;
	    case _C_: readc();	 break;
	}
	closeinput();
	computewidth();
}

static void convertfont(void)
{
	if(opt.verbose) {
	    printf("processing...\t");
	    fflush(stdout);
	}
	if(opt.do_prop2fix) cvtprop2fix();
	if(opt.do_fix2prop) cvtfix2prop();
	if(opt.do_centerwdt) centerwidth();
	if(opt.do_centerhgt) centerheight();
}

static void savefont(void)
{
	char *p;

	if((p = strrchr(fnt.name,'.')) != NULL) *p = '\0';
	switch(opt.outtype) {
	    case FNA: strcat(fnt.name,".fna"); break;
	    case FNT: strcat(fnt.name,".fnt"); break;
	    case _C_: strcat(fnt.name,".c");   break;
	}
	openoutput(fnt.name,(opt.outtype == FNT) ? "wb" : "w");
	if(opt.verbose) {
	    printf("writing \"%s\"...\t",outname);
	    fflush(stdout);
	}
	if((p = strrchr(fnt.name,'\\')) != NULL) strcpy(fnt.name,++p);
	if((p = strrchr(fnt.name,'/'))  != NULL) strcpy(fnt.name,++p);
	if((p = strrchr(fnt.name,':'))  != NULL) strcpy(fnt.name,++p);
	for(p = fnt.name; *p != '\0'; p++) *p = tolower(*p);
	switch(opt.outtype) {
	    case FNA: writefna(); break;
	    case FNT: writefnt(); break;
	    case _C_: writec();	  break;
	}
	closeoutput();
}

static void enforceoptions(void)
{
	char *pp,*np;
	chr  *cp,*nxt;

	if(*(pp = opt.namepattern) != '\0') {
	    char unique = '\0';
	    for( ; ; ) {
		for(np = fnt.name; *pp != '\0'; pp++) {
		    if(*pp == '%') switch(*++pp) {
		      case '%':
			*np++ = '%';
			break;
		      case 'W': case 'w':
			sprintf(np,"%d",fnt.avgwidth);
			np += strlen(np);
			break;
		      case 'H': case 'h':
			sprintf(np,"%d",fnt.height);
			np += strlen(np);
			break;
		      case 'G': case 'g':
			if(fnt.weight[0] != '\0') *np++ = fnt.weight[0];
			break;
		      case 'S': case 's':
			if(fnt.slant[0] != '\0') *np++ = fnt.slant[0];
			break;
		      case 'U': case 'u':
			if(unique != '\0') {
			    *np++ = unique;
			    unique++;
			    if((unique == 'b') || (unique == 'i')) unique++;
			    break;
			}
			unique = 'a';
			break;
		    }
		    else *np++ = *pp;
		}
		*np = '\0';
		if(unique == '\0') break;
		if((pp = strrchr(fnt.name,'.')) != NULL) *pp = '\0';
		switch(opt.outtype) {
		    case FNA: strcat(fnt.name,".fna"); break;
		    case FNT: strcat(fnt.name,".fnt"); break;
		    case _C_: strcat(fnt.name,".c");   break;
		}
		if(access(fnt.name,F_OK) != 0) break;
		pp = opt.namepattern;
	    }
	}
	if(opt.family[0] != '\0') strcpy(fnt.family,opt.family);
	if(fnt.minchar < opt.minchar) {
	    for(cp = fnt.chars; cp != NULL; cp = nxt) {
		nxt = cp->next;
		if(cp->code == opt.minchar) {
		    fnt.minchar = cp->code;
		    fnt.chars = cp;
		    break;
		}
		free(cp->bmp);
		free(cp);
	    }
	    computewidth();
	}
	if(fnt.maxchar > opt.maxchar) {
	    for(cp = fnt.chars; cp != NULL; cp = nxt) {
		nxt = cp->next;
		if(cp->code == opt.maxchar) {
		    fnt.maxchar = cp->code;
		    cp->next = NULL;
		}
		if(cp->code > opt.maxchar) {
		    free(cp->bmp);
		    free(cp);
		}
	    }
	    computewidth();
	}
}

static void destroyfont(void)
{
	chr *cp,*nxt;

	for(cp = fnt.chars; cp != NULL; cp = nxt) {
	    nxt = cp->next;
	    free(cp->bmp);
	    free(cp);
	}
	memset(&fnt,0,sizeof(font));
	notes[0] = '\0';
}

void processfonts(int argc,char **argv)
{
	if(opt.outtype == DIR) {
	    if(opt.verbose)
		printf("  creating font directory: \"%s\"\n",opt.namepattern);
	    openoutput(opt.namepattern,"wb");
	    writedir(argc,argv);
	    closeoutput();
	}
	else while(--argc >= 0) {
	    loadfont(*argv++);
	    convertfont();
	    enforceoptions();
	    if(opt.do_show) showfont();
	    if(opt.do_edit) editfont();
	    savefont();
	    destroyfont();
	    if(opt.verbose) {
		printf("done\n");
		fflush(stdout);
	    }
	}
}

