/**
 ** GENELLIP.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "libgrx.h"
#include "clipping.h"
#include <string.h>

#define TABLEN  256

static unsigned int sintab[] = {
	0,   101,   201,   302,	  402,	 503,	603,   704,
      804,   904,  1005,  1105,  1205,  1306,  1406,  1506,
     1606,  1706,  1806,  1906,  2006,  2105,  2205,  2305,
     2404,  2503,  2603,  2702,  2801,  2900,  2999,  3098,
     3196,  3295,  3393,  3492,  3590,  3688,  3786,  3883,
     3981,  4078,  4176,  4273,  4370,  4467,  4563,  4660,
     4756,  4852,  4948,  5044,  5139,  5235,  5330,  5425,
     5520,  5614,  5708,  5803,  5897,  5990,  6084,  6177,
     6270,  6363,  6455,  6547,  6639,  6731,  6823,  6914,
     7005,  7096,  7186,  7276,  7366,  7456,  7545,  7635,
     7723,  7812,  7900,  7988,  8076,  8163,  8250,  8337,
     8423,  8509,  8595,  8680,  8765,  8850,  8935,  9019,
     9102,  9186,  9269,  9352,  9434,  9516,  9598,  9679,
     9760,  9841,  9921, 10001, 10080, 10159, 10238, 10316,
    10394, 10471, 10549, 10625, 10702, 10778, 10853, 10928,
    11003, 11077, 11151, 11224, 11297, 11370, 11442, 11514,
    11585, 11656, 11727, 11797, 11866, 11935, 12004, 12072,
    12140, 12207, 12274, 12340, 12406, 12472, 12537, 12601,
    12665, 12729, 12792, 12854, 12916, 12978, 13039, 13100,
    13160, 13219, 13279, 13337, 13395, 13453, 13510, 13567,
    13623, 13678, 13733, 13788, 13842, 13896, 13949, 14001,
    14053, 14104, 14155, 14206, 14256, 14305, 14354, 14402,
    14449, 14497, 14543, 14589, 14635, 14680, 14724, 14768,
    14811, 14854, 14896, 14937, 14978, 15019, 15059, 15098,
    15137, 15175, 15213, 15250, 15286, 15322, 15357, 15392,
    15426, 15460, 15493, 15525, 15557, 15588, 15619, 15649,
    15679, 15707, 15736, 15763, 15791, 15817, 15843, 15868,
    15893, 15917, 15941, 15964, 15986, 16008, 16029, 16049,
    16069, 16088, 16107, 16125, 16143, 16160, 16176, 16192,
    16207, 16221, 16235, 16248, 16261, 16273, 16284, 16295,
    16305, 16315, 16324, 16332, 16340, 16347, 16353, 16359,
    16364, 16369, 16373, 16376, 16379, 16381, 16383, 16384,
    16384
};

int _GrGenerateEllipse(int pt[][2],int cx,int cy,int rx,int ry)
{
#undef  WHEN_OUTSIDE
#define WHEN_OUTSIDE	return(0)
#define ulong	unsigned long
	int x1,x2,y1,y2;
	int nn,n2,n4;
	int ii,dx,dy;
	int gap,theta;

	if(rx < 0) rx = (-rx);
	if(ry < 0) ry = (-ry);
	x1 = cx - rx;  y1 = cy - ry;
	x2 = cx + rx;  y2 = cy + ry;
	CLIPSORTEDBOX(CURC,x1,y1,x2,y2);
	if((rx == 0) || (ry == 0)) {
	    pt[0][0] = cx - rx; pt[0][1] = cy - ry;
	    pt[0][1] = cx + rx; pt[0][1] = cy + ry;
	    return(((rx == 0) && (ry == 0)) ? 1 : 2);
	}
	n2 = rx + ry;
	if(n2 > 128) n2 >>= 1;
	for(nn = 32; nn < n2; nn <<= 1);
	if(n2 > MAX_ELLIPSE_PTS) nn = MAX_ELLIPSE_PTS;
	n2 = nn >> 1;
	n4 = n2 >> 1;
	gap = TABLEN / n4;
	for(ii = theta = 0; ii <= n4; ii++,theta += gap) {
	    dx = (int)((((ulong)rx * (ulong)sintab[TABLEN - theta]) + 8192UL) >> 14);
	    dy = (int)((((ulong)ry * (ulong)sintab[theta]) + 8192UL) >> 14);
	    pt[ii][0]	 = cx + dx;
	    pt[ii][1]	 = cy - dy;
	    pt[n2-ii][0] = cx - dx;
	    pt[n2-ii][1] = cy - dy;
	    pt[n2+ii][0] = cx - dx;
	    pt[n2+ii][1] = cy + dy;
	    pt[nn-ii][0] = cx + dx;
	    pt[nn-ii][1] = cy + dy;
	}
	return(nn);
}


/* for BCC2GRX -- to be made static later */
int _grx_arc_xs, _grx_arc_ys;
int _grx_arc_xe, _grx_arc_ye;
int _grx_arc_xc, _grx_arc_yc;

int _GrGenerateEllipseArc(int pt[][2],int cx,int cy,int rx,int ry,int start,int end,int filled)
{
#define interp(p1,f1,p2,f2,div) \
	(int)((((long)(p1) * (long)(f1)) + ((long)(p2) * (long)(f2))) / (long)(div))

	int tmp[MAX_ELLIPSE_PTS+1][2];
	int nfinal,nn = _GrGenerateEllipse(tmp,cx,cy,rx,ry);
	int angle1,angle2;
	int index1,index2;
	int fract1,fract2;
	int x1,y1,x2,y2;

	if(nn <= 2) return(0);
	if((angle1 = start % 3600) < 0) angle1 += 3600;
	if((angle2 = end   % 3600) < 0) angle2 += 3600;
	index1 = (int)(((ulong)angle1 * (ulong)nn) / 3600UL);
	fract1 = (int)(((ulong)angle1 * (ulong)nn) % 3600UL);
	index2 = (int)(((ulong)angle2 * (ulong)nn) / 3600UL);
	fract2 = (int)(((ulong)angle2 * (ulong)nn) % 3600UL);
	x1 = tmp[index1][0];
	y1 = tmp[index1][1];
	x2 = tmp[index2][0];
	y2 = tmp[index2][1];
	if(fract1 != 0) {
	    x1 = interp(x1,(3600 - fract1),tmp[index1+1][0],fract1,3600);
	    y1 = interp(y1,(3600 - fract1),tmp[index1+1][1],fract1,3600);
	}
	if(fract2 != 0) {
	    x2 = interp(x2,(3600 - fract2),tmp[index2+1][0],fract2,3600);
	    y2 = interp(y2,(3600 - fract2),tmp[index2+1][1],fract2,3600);
	    index2++;
	}
	if((x1 == x2) && (y1 == y2)) {
	    if(start == end) {
		pt[0][0] = x1;
		pt[0][1] = y1;
		if(filled) {
		    pt[1][0] = cx;
		    pt[1][1] = cy;
		    return(2);
		}
		return(1);
	    }
	    memcpy(pt,tmp,(sizeof(int[2]) * nn));
	    return(-nn);
	}
	if(angle2 >= angle1) {
	    nfinal = index2 - index1 + 1;
	    memcpy(pt,&tmp[index1],(sizeof(int[2]) * nfinal));
	}
	else {
	    nfinal = index2 + nn - index1 + 1;
	    start = nn - index1;
	    end	  = index2 + 1;
	    memcpy(pt,&tmp[index1],(sizeof(int[2]) * start));
	    memcpy(&pt[start],tmp,(sizeof(int[2]) * end));
	}
	pt[0][0] = x1;
	pt[0][1] = y1;
	pt[nfinal-1][0] = x2;
	pt[nfinal-1][1] = y2;
	_grx_arc_xs = x1; _grx_arc_ys = y1;
	_grx_arc_xe = x2; _grx_arc_ye = y2;
	_grx_arc_xc = cx; _grx_arc_yc = cy;
	if(filled) {
	    pt[nfinal][0] = cx;
	    pt[nfinal][1] = cy;
	    return(nfinal + 1);
	}
	return(nfinal);
}

void GrGetLastArcCoords(int *xs,int *ys,int *xe,int *ye,int *xc,int *yc)
{
	*xs = _grx_arc_xs; *ys = _grx_arc_ys;
	*xe = _grx_arc_xe; *ye = _grx_arc_ye;
	*xc = _grx_arc_xc; *yc = _grx_arc_yc;
}

