#
# MAKEFILE.TCC
#   for building the Turbo C version of the GRX library
#   usage: make [-DPLANE=<planes>] [-DMODEL=<Turbo C memory model>] [-DDEBUG]
#

!if !$d(MODEL)
MODEL = l
!endif

!if $d(DEBUG)
TCCDBG= -v
!endif

!if !$d(PLANE)
PLANE = 255
TCCLIB= ..\lib\grx$(MODEL).lib
TSTAMP= stamp$(MODEL).tcc
!else
TCCLIB= ..\lib\grx$(PLANE)$(MODEL).lib
TSTAMP= stamp$(PLANE)$(MODEL).tcc
!endif

MODE_X= 32
M_8514= 64
M_S3=	128

#
# compiler options
#
CPPOPT= -I../include -DGRXPLANES=$(PLANE)
TCCOPT= -O -G -Z -N- -w -d -r -m$(MODEL) $(CPPOPT) $(TCCDBG)

#
# default rules:
#    C -> ASM rules are there to look at the generated code
#    when using inline assembly
#
.c.obj:
	tcc -c $(TCCOPT) $(TDEBUG) { $*.c }

.c.asm:
	tcc -S $(TCCOPT) $*.c

#
# default targets:
#
all:	$(TSTAMP) $(TCCLIB)

#
# stamp files for keeping the objects consistent
#
$(TSTAMP): ../include/grx.h
	-del *.obj
	-del stamp*.tcc
	echo stamp >$(TSTAMP)


#
# objects for building the Turbo C library
#
TINIT=  layout.obj   setmode.obj  context.obj  setclip.obj  colors.obj

TMISC=  fileutil.obj reslist.obj  cursor.obj   mouse.obj    bestfont.obj \
	gmalloc.obj  vmalloc.obj  makepat.obj

TDRAW=  clear.obj    plot.obj	  hline.obj    vline.obj    line.obj	 \
	box.obj	     fillbox.obj  frambox.obj  circle.obj   pixel.obj	 \
	bitblt.obj   drawpoly.obj fillpoly.obj patfbox.obj  scancnvx.obj \
	scanpoly.obj scanfill.obj scanpatt.obj fillcvxp.obj genellip.obj \
	fillcirc.obj patfpoly.obj custcirc.obj \
	patfcvxp.obj patfcirc.obj patfplot.obj patfline.obj \
	solidln.obj  solidpix.obj scanellp.obj polygon.obj  thicklne.obj \
	custline.obj custpoly.obj pattline.obj pattcirc.obj pattpoly.obj

TUSER=  usercord.obj uplot.obj	  uline.obj    uhline.obj   uvline.obj	 \
	ubox.obj     ufillbox.obj uframbox.obj ucircle.obj  upixel.obj	 \
	ubestfnt.obj udrawtxt.obj

TNCLIP= plotnc.obj   linenc.obj	  vlinenc.obj  hlinenc.obj  boxnc.obj	 \
	fillbxnc.obj frambxnc.obj pixelnc.obj  bitbltnc.obj

TTEXT=  drawtext.obj dumptext.obj loadfont.obj textsize.obj biosfont.obj

#
# Turbo C version specific modules
#
TCCAUX= loaddrv.obj  tcgetkey.obj

#
# Event queue library objects
#
TEVENT= ../events/event.ob$(MODEL)	../events/nextevnt.ob$(MODEL)	 \
	../events/evintr.obj

#
# low-level mode-dependent drivers
#
!if ($(PLANE) & 1)
P1T=	p1pixrd.obj	p1pixset.obj \
	p1pixrow.obj	p1pixcol.obj \
	p1pixblk.obj	p1bitblt.obj \
	p1line.obj	p1char.obj   \
	p1fillp.obj
!endif

!if ($(PLANE) & 4)
P4T=	p4pixrd.obj	p4pixset.obj \
	p4pixrow.obj	p4pixcol.obj \
	p4pixblk.obj	p4bitblt.obj \
	p4line.obj	p4char.obj   \
	p4fillp.obj	p4init.obj
!endif

!if ($(PLANE) & ($(M_8514) | $(M_S3) | 8))
P8T=	p8pixrd.obj	p8pixset.obj \
	p8pixrow.obj	p8pixcol.obj \
	p8pixblk.obj	p8bitblt.obj \
	p8line.obj	p8char.obj   \
	p8fillp.obj	p8init.obj
!endif

!if ($(PLANE) & $(MODE_X))
PXT=	pxpixrd.obj	pxpixset.obj \
	pxpixrow.obj	pxpixcol.obj \
	pxpixblk.obj	pxbitblt.obj \
	pxline.obj	pxchar.obj   \
	pxfillp.obj
!endif

!if ($(PLANE) & ($(M_8514) | $(M_S3)))
PIT=	pipixrd.obj	pipixset.obj \
	pipixrow.obj	pipixcol.obj \
	pipixblk.obj	pibitblt.obj \
	piline.obj	pichar.obj   \
	pifillp.obj	piinit.obj
!endif

!if($(PLANE) & $(M_S3))
PST=	pschar.obj	psfillp.obj
!endif

!if ($(PLANE) != 1)  && ($(PLANE) != 4)  && ($(PLANE) != 8)
!if ($(PLANE) != 16) && ($(PLANE) != 32) && ($(PLANE) != 64)
!if ($(PLANE) != 128)
SWT=	swpixrd.obj	swpixset.obj \
	swpixrow.obj	swpixcol.obj \
	swpixblk.obj	swbitblt.obj \
	swline.obj	swchar.obj   \
	swfillp.obj	voiddrv.obj
!endif
!endif
!endif

#
# build the library
#
TCCOBJ= $(TINIT)    $(TMISC)	$(TDRAW)    $(TUSER)	$(TNCLIP)   \
	$(TTEXT)    $(TCCAUX)	$(P1T)	    $(P4T)	$(P8T)	    \
	$(PXT)	    $(PIT)	$(PST)	    $(SWT)	_todo.obj

$(TCCLIB): $(TCCOBJ) ..\utils\tlibcvt.exe
	-del $(TCCLIB)
	..\utils\tlibcvt + &&!
	$(TCCOBJ)
	$(TEVENT)
!	$(TMP)\tlib.cmd
	tlib $(TCCLIB) /C @$(TMP)\tlib.cmd

..\utils\tlibcvt.exe: ..\utils\tlibcvt.c
	cd ..\utils
	tcc tlibcvt.c
	del tlibcvt.obj
	cd ..\src

#
# dependencies
#
INC=		../include
GRX_H=		$(INC)/grx.h libgrx.h
LINECLIP_H=	lineclip.h scale.h clipping.h
USERCORD_H=	usercord.h scale.h
P4_H=		$(GRX_H) p4.h vgaregs.h
P8_H=		$(GRX_H) p8.h vgaregs.h
P8514A_H=	$(GRX_H) p8514a.h reg8514a.h

bestfont.obj:	$(GRX_H) $(INC)/grxfile.h gmalloc.h
biosfont.obj:	$(GRX_H) $(INC)/grxfont.h $(INC)/grxfile.h interrup.h
bitblt.obj:	$(GRX_H) clipping.h
bitbltnc.obj:	$(GRX_H)
box.obj:	$(GRX_H)
boxnc.obj:	$(GRX_H) fakeclip.h box.c
circle.obj:	$(GRX_H)
clear.obj:	$(GRX_H)
colors.obj:	$(GRX_H) interrup.h gmalloc.h reg8514a.h
context.obj:	$(GRX_H) clipping.h gmalloc.h
cursor.obj:	$(GRX_H) $(INC)/mousex.h gmalloc.h
custcirc.obj:	$(GRX_H) thicklne.h
custline.obj:	$(GRX_H) thicklne.h
custpoly.obj:	$(GRX_H) thicklne.h
drawpoly.obj:	$(GRX_H)
drawtext.obj:	$(GRX_H) $(INC)/grxfont.h clipping.h gmalloc.h memfill.h memcopy.h
dumptext.obj:	$(GRX_H) $(INC)/grxfont.h clipping.h
fileutil.obj:	$(GRX_H) $(INC)/grxfile.h
fillbox.obj:	$(GRX_H) clipping.h
fillbxnc.obj:	$(GRX_H) fakeclip.h fillbox.c
fillcirc.obj:	$(GRX_H)
fillcvxp.obj:	$(GRX_H)
fillpoly.obj:	$(GRX_H)
frambox.obj:	$(GRX_H)
frambxnc.obj:	$(GRX_H) fakeclip.h frambox.c
genellip.obj:	$(GRX_H)
gmalloc.obj:	gmalloc.h
hline.obj:	$(GRX_H) clipping.h
hlinenc.obj:	$(GRX_H) fakeclip.h hline.c
layout.obj:	$(GRX_H)
line.obj:	$(GRX_H) $(LINECLIP_H)
linenc.obj:	$(GRX_H) fakeclip.h line.c
loaddrv.obj:	$(GRX_H) $(INC)/grxfile.h $(INC)/grxfont.h gmalloc.h
loadfont.obj:	$(GRX_H)
makepat.obj:	$(GRX_H) $(INC)/mousex.h interrup.h clipping.h $(EVTINC)
mouse.obj:	$(GRX_H) clipping.h
patfbox.obj:	$(GRX_H)
patfcirc.obj:	$(GRX_H)
patfcvxp.obj:	$(GRX_H) $(LINECLIP_H)
patfline.obj:	$(GRX_H) clipping.h
patfplot.obj:	$(GRX_H)
patfpoly.obj:	$(GRX_H) thicklne.h
pattcirc.obj:	$(GRX_H) thicklne.h
pattline.obj:	$(GRX_H) thicklne.h
pattpoly.obj:	$(GRX_H) clipping.h
pixel.obj:	$(GRX_H) fakeclip.h pixel.c
pixelnc.obj:	$(GRX_H) clipping.h
plot.obj:	$(GRX_H) fakeclip.h plot.c
plotnc.obj:	$(GRX_H)
polygon.obj:	$(GRX_H) $(INC)/grxfile.h gmalloc.h
reslist.obj:	$(GRX_H) clipping.h
scanellp.obj:	$(GRX_H) clipping.h scale.h
scancnvx.obj:	$(GRX_H) clipping.h
scanfill.obj:	$(GRX_H) clipping.h
scanpatt.obj:	$(GRX_H) clipping.h scale.h gmalloc.h
scanpoly.obj:	$(GRX_H) clipping.h
setclip.obj:	$(GRX_H) $(INC)/grdriver.h
setmode.obj:	$(GRX_H) lineclip.h
solidln.obj:	$(GRX_H) clipping.h
solidpix.obj:	$(GRX_H) $(INC)/grxfont.h
textsize.obj:	$(GRX_H) thicklne.h clipping.h
tcgetkey.obj:	$(GRX_H) scale.h
thicklne.obj:	$(GRX_H) $(USERCORD_H)
ubestfnt.obj:	$(GRX_H) $(USERCORD_H)
ubox.obj:	$(GRX_H) $(USERCORD_H)
ucircle.obj:	$(GRX_H) $(USERCORD_H)
udrawtxt.obj:	$(GRX_H) $(USERCORD_H)
ufillbox.obj:	$(GRX_H) $(USERCORD_H)
uframbox.obj:	$(GRX_H) $(USERCORD_H)
uhline.obj:	$(GRX_H) $(USERCORD_H)
uline.obj:	$(GRX_H) $(USERCORD_H)
upixel.obj:	$(GRX_H) $(USERCORD_H)
uplot.obj:	$(GRX_H) $(USERCORD_H)
usercord.obj:	$(GRX_H) clipping.h
uvline.obj:	$(GRX_H) fakeclip.h vline.c
vline.obj:	gmalloc.h

vlinenc.obj:	$(GRX_H)
vmalloc.obj:	$(GRX_H)
p1bitblt.obj:	$(GRX_H)
p1char.obj:	$(GRX_H)
p1fillp.obj:	$(GRX_H)
p1line.obj:	$(GRX_H)
p1pixblk.obj:	$(GRX_H)
p1pixcol.obj:	$(GRX_H)
p1pixrd.obj:	$(GRX_H)

p4init.obj:	$(P4_H) gmalloc.h $(INC)/grdriver.h
p4bitblt.obj:	$(P4_H) memcopy.h bitcopy.h gmalloc.h
p4char.obj:	$(P4_H) memfill.h memcopy.h bitdraw.h
p4fillp.obj:	$(P4_H) memfill.h memcopy.h
p4line.obj:	$(P4_H) bitdraw.h
p4pixblk.obj:	$(P4_H) memfill.h memcopy.h
p4pixcol.obj:	$(P4_H) memfill.h
p4pixrd.obj:	$(P4_H)
p4pixrow.obj:	$(P4_H) memfill.h memcopy.h
p4pixset.obj:	$(P4_H)

p8init.obj:	$(P8_H) $(INC)/grdriver.h
p8bitblt.obj:	$(P8_H) memcopy.h gmalloc.h
p8char.obj:	$(P8_H) bytedraw.h
p8fillp.obj:	$(P8_H) memcopy.h bytedraw.h gmalloc.h
p8line.obj:	$(P8_H) bytedraw.h
p8pixblk.obj:	$(P8_H) memfill.h
p8pixcol.obj:	$(P8_H) memfill.h
p8pixrd.obj:	$(P8_H)
p8pixrow.obj:	$(P8_H) memfill.h
p8pixset.obj:	$(P8_H)

piinit.obj:	$(P8514A_H)
pibitblt.obj:	$(P8514A_H)
pichar.obj:	$(P8514A_H)
pifillp.obj:	$(P8514A_H)
piline.obj:	$(P8514A_H)
pipixblk.obj:	$(P8514A_H)
pipixcol.obj:	$(P8514A_H)
pipixrd.obj:	$(P8514A_H)
pipixrow.obj:	$(P8514A_H)
pipixset.obj:	$(P8514A_H)

pschar.obj:	$(P8514A_H)
psfillp.obj:	$(P8514A_H)

pxbitblt.obj:	$(GRX_H)
pxchar.obj:	$(GRX_H)
pxfillp.obj:	$(GRX_H)
pxline.obj:	$(GRX_H)
pxpixblk.obj:	$(GRX_H)
pxpixcol.obj:	$(GRX_H)
pxpixrd.obj:	$(GRX_H)
pxpixrow.obj:	$(GRX_H)
pxpixset.obj:	$(GRX_H)

swbitblt.obj:	$(GRX_H)
swchar.obj:	$(GRX_H)
swfillp.obj:	$(GRX_H)
swline.obj:	$(GRX_H)
swpixblk.obj:	$(GRX_H)
swpixcol.obj:	$(GRX_H)
swpixrd.obj:	$(GRX_H)
swpixrow.obj:	$(GRX_H)
swpixset.obj:	$(GRX_H)
voiddrv.obj:	$(GRX_H)

