/**
 ** P4LINE.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "p4.h"
#include "bitdraw.h"

void _GrP4DrawLine(long addr,int color,int deltax,int deltay)
{
	pixptr p  = P_ADDRESS(CURC,addr);
	int mask = 0x80 >> P_OFFSET(addr);
	int offs = CURC->gc_lineoffset;
	int oper = C_OPER(color);
	int plane;

	if((_GrP4DrawTable[oper] ^ (color &= C_SIGNIF)) == 0) return;
	if(deltay < 0) { deltay = (-deltay); offs = (-offs); }
	if(CURC->gc_onscreen) {
	    if(_GrAdapterType == GR_VGA) {
		_SetVGAWriteMode(8+3);
		_SetVGAWriteMask(0xff);
		_SetVGADontCareRegister(0x00);
		_SetVideoColor(color,oper);
		_DrawLineVGA(p,offs,deltax,deltay,mask);
		_SetVGAWriteMode(0);
	    }
	    else {
		_SetVideoColor(color,oper);
		_DrawLineEGA(p,offs,deltax,deltay,mask);
	    }
	    return;
	}
	oper <<= 1;
	for(plane = 4; --plane >= 0; color >>= 1) {
	    switch(oper | (color & 1)) {
	      case C_XOR2+1:
		_DrawLineXor(p,offs,deltax,deltay,mask);
		break;
	      case C_OR2+1:
	      case C_SET2+1:
		_DrawLineOr(p,offs,deltax,deltay,mask);
		break;
	      case C_AND2+0:
	      case C_SET2+0:
		_DrawLineAnd(p,offs,deltax,deltay,mask);
		break;
	    }
	    p = (pixptr)((long)p + CURC->gc_planeoffset);
	}
}

