/**
 ** TCGETKEY.C
 **
 **  Copyright (C) 1992, Csaba Biegl
 **    820 Stirrup Dr, Nashville, TN, 37221
 **    csaba@vuse.vanderbilt.edu
 **
 **  This file is distributed under the terms listed in the document
 **  "copying.cb", available from the author at the address above.
 **  A copy of "copying.cb" should accompany this file; if not, a copy
 **  should be available from where this file was obtained.  This file
 **  may not be distributed without a verbatim copy of "copying.cb".
 **  You should also have received a copy of the GNU General Public
 **  License along with this program (it is in the file "copying");
 **  if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 **  Cambridge, MA 02139, USA.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **/

#include "grx.h"
#include "mousex.h"
#include <dos.h>

#ifdef USE_AT_BIOS
#define BIOS_CALL_OFFSET	0x1000
#else
#define BIOS_CALL_OFFSET	0
#endif

int getkey(void)
{
	_AX = 0 + BIOS_CALL_OFFSET;
	geninterrupt(0x16);
#ifdef USE_AT_BIOS
	return(((_AL != 0) && (_AL != 0xe0)) ? _AL : _AH + 0x100);
#else
	return((_AL != 0) ? _AL : _AH + 0x100);
#endif
}

int getxkey(void)
{
	_AX = 0 + BIOS_CALL_OFFSET;
	geninterrupt(0x16);
#ifdef USE_AT_BIOS
	return((_AL == 0) ? _AH + 0x100 : (_AL == 0xe0) ? _AH + 0x200 : _AL);
#else
	return((_AL != 0) ? _AL : _AH + 0x100);
#endif
}

int getkbstat(void)
{
	_AX = 0x200 + BIOS_CALL_OFFSET;
	geninterrupt(0x16);
	return(_AL);
}

