#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static void usage(char *message,...)
{
	va_list ap;

	if(message != NULL) {
	    va_start(ap,message);
	    vfprintf(stderr,message,ap);
	    va_end(ap);
	    fprintf(stderr,"\n\n");
	}
	fprintf(stderr,
	    "Usage: TLIBCVT <option> [<infile> [<outfile>]]\n\n"
	    "    OPTION: TLIB object file option (+, -, +-, *, *+, etc..)\n"
	    "        see manual for details\n"
	    "    INFILE: input file containing the names of the object\n"
	    "        files. If omitted, stdin is used.\n"
	    "    OUTFILE: name of the output TLIB response file.\n"
	    "       If omitted, stdin is used.\n\n"
	    "Converts a list of object files to TLIB\n"
	    "(Turbo C Librarian) response file format\n\n"
	);
	exit(-1);
}

void main(int argc,char **argv)
{
	char filename[100];
	char *option,*p;
	int  len,pos = 0;

	if(argc < 2) usage(NULL);
	option = argv[1];
	if((argc > 2) && (freopen(argv[2],"r",stdin) == NULL))
	    usage("can't open input file: %s",argv[2]);
	if((argc > 3) && (freopen(argv[3],"w",stdout) == NULL))
	    usage("can't create output file: %s",argv[3]);
	while(scanf("%s",filename) == 1) {
	    len = strlen(filename) + strlen(option) + 1;
	    for(p = filename; *p != '\0'; p++) {
		*p = toupper(*p);
		if(*p == '/') *p = '\\';
	    }
	    if((pos + len) > 75) {
		printf(" &\n %s%s",option,filename);
		pos = len;
	    }
	    else {
		printf(" %s%s",option,filename);
		pos += len;
	    }
	}
	printf("\n");
	exit(0);
}

