/*
 * DESQview/X System Library, Copyright Quarterdeck Office Systems (c) 1991
 */

#ifndef _PMI_H_
#define _PMI_H_

#define ushort unsigned short
#define ulong unsigned long

#if defined(__HIGHC__)
  #define farptr _far *
  #define farstruct(a) _far struct a
  #define SMALLMODEL
#else  /* __HIGHC__ */
#ifdef __ZTC__
  #define farptr _far *
  #define farstruct(a) struct a _far
  #ifdef DOS386
    #define SMALLMODEL
  #endif /* DOS386 */
#else /* __ZTC__ */
#ifdef __WATCOMC__
  #define farptr _far *
  #define farstruct(a) struct a _far
  #define SMALLMODEL
#else /* __WATCOMC__ */
#if 0 /* def M_I86SM */
  #define farptr _far *
  #define farstruct(a) struct a _far
#else /* M_I86SM */
  #define farptr *
  #define farstruct(a) struct a
#endif /* M_I86SM */
#endif /* __WATCOMC__ */
#endif /* __ZTC__ */
#endif /* __HIGHC__ */

#ifdef __WATCOMC__
#define CDECL __cdecl
#else
#define CDECL
#endif

#ifdef SMALLMODEL
  extern void CDECL memcpyNearToFar(void farptr, void *, int);
  extern void CDECL memcpyFarToNear(void *, void farptr, int);
  extern int  CDECL strcmpFarToNear(char *, char farptr);
  extern void CDECL strcpyNearToFar(char farptr, char *);
  extern void CDECL strcpyFarToNear(char *, char farptr);
  extern void CDECL strncpyFarToNear(char *, char farptr, int);
  extern int  CDECL strlenFar(char farptr);
  #undef SMALLMODEL
#else /* SMALLMODEL */
#if 0 /* def M_I86SM */
  #define memcpyNearToFar(d,s,n) _fmemcpy(d,s,n)
  #define memcpyFarToNear(d,s,n) _fmemcpy(d,s,n)
  #define strcmpFarToNear(d,s) _fstrcmp(d,s)
  #define strcpyNearToFar(d,s) _fstrcpy(d,s)
  #define strcpyFarToNear(d,s) _fstrcpy(d,s)
  #define strncpyFarToNear(d,s,n) _fstrncpy(d,s,n)
  #define strlenFar(s) _fstrlen(s)
#else /* M_I86SM */
  #define memcpyNearToFar(d,s,n) memcpy(d,s,n)
  #define memcpyFarToNear(d,s,n) memcpy(d,s,n)
  #define strcmpFarToNear(d,s) strcmp(d,s)
  #define strcpyNearToFar(d,s) strcpy(d,s)
  #define strcpyFarToNear(d,s) strcpy(d,s)
  #define strncpyFarToNear(d,s,n) strncpy(d,s,n)
  #define strlenFar(s) strlen(s)
#endif /* M_I86SM */
#endif /* SMALLMODEL */

extern char farptr pmiSegAbsolute(ushort, ushort, ushort);
extern void pmiSegCancel(void farptr);

#endif /* _PMI_H_ */
